(function ($) {
	"use strict";
    
    $(document).on('click', ".hide_notification", function () {
        var id = $(this).attr('data-id');
        var payment = $(this).attr('data-payment');
        hide_notification(payment, id);
    });
    $(document).on('click', ".change_notification_status", function () {
        var id = $(this).attr('data-id');
        var status = $(this).attr('data-status');
        var name = $(this).attr('data-name');
        change_notification_status(id,status,name);
    });
    $("#notification_alldata").hide();
    $('.save_newchat').on('click', function () {
        save_newchat();
    });

    $('.send_follow_request').on('click', function () {
        send_follow_request();
    });
	
	
	$(document).on('click', ".purchaseMsgPop", function () {
		var dataId=$(this).attr('data-seller_id');
		$("#sell_gigs_userid").val(dataId);		
		var url = base_url+'user/purchases/get_user_content';		
		var dataString="f_id="+dataId; 
		$.ajax({
			url:url,
			data:dataString,
			type:"POST",
			dataType: 'json',
			success: function(res){ 				
				$("#msg_user_details").html('').html(res.user_content);					
			}
		});
	});

    function get_notification_count() {
        var url = base_url + 'user/notification/get_notification_count';
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: url,
            success: function (data) {
                if (data.new_total > 0) {
                    $(".notification_count").html(data.new_total);
                    $(".notification_count").show();
                    $("#notification_alldata").show();
                    var ts = '<div class="notification-items">' + data.new_data + '</div>';
                    $("#notification_notification").html(ts);
                }
                else {
                    $(".notification_count").hide();
                    $("#notification_alldata").hide();
                    $("#notification_notification").html('');
                }
            }
        });
    }

    function mail_notification() {
        var url = base_url + 'user/notification/mail_notification';
        $.ajax({
            type: 'post',
            url: url,
            success: function (data) {

            }
        });
    }
	
    function get_notification() {
        var url = base_url + 'user/notification/get_new_notification';
        $.ajax({
            type: 'post',
            url: url,
            success: function (data) {
                $('.notification_list').html('');
                $('.notification_list').append(data);
            }
        });
    }

    function hide_notification(table_name, id) {
        var url = base_url + 'user/notification/update_notification';
		table_name = table_name.replace(/["']/g, "");
        $.ajax({
            type: 'post',
            url: url,
            data: { table_name: table_name, id: id },
            success: function (data) {
                if (data == 1) {
                    $('#remove_' + table_name + '_' + id).remove();
                }
				
				if($('.list-group.notify-list li').length == 0){
					location.reload();
				} 

            }
        });
    }


    $(document).ready(function () {
        setInterval(function () {
            get_notification_count();
        }, 20000);
        var param = 0;
        get_all_new_chats_count(param);
        get_notification_count();
    });


    function update_notification() {
        var url = base_url + 'user/notification/update_notification';
        $.ajax({
            type: 'post',
            url: url,
            success: function (data) {
                if (data) {
                    $('#notification_count').html();
                    window.location.href = base_url() + 'notification';
                }
            }
        });
    }
	
    function save_newchat() {
        var chat_id = $('#sell_gigs_userid').val();
        var chat_content = $('textarea#messageone').val();
        $("#_error_").html('');
        if (chat_id) {
            var form = $("#form_messagecontent_id");
            if (chat_content.length > 0) {
				$("textarea#messageone").removeAttr('style');
                var url = base_url + 'user/chat/save_buyerchat';

                $.ajax({
                    url: url,
                    type: "POST",
                    data: form.serialize(),
                    /*dataType: 'json',*/
					cache: false,
                    success: function (res) {
                        if (res == 1) {
                            $('textarea#messageone').val('');
                            $('textarea#messageone').text('');
                            $('#message-popup').modal('toggle');
                            $('#form_messagecontent_id')[0].reset();
                            swal({
                                title: success,
                                text: message_send_success,
                                icon: "success",
                                button: "okay",
                                closeOnEsc: false,
                                closeOnClickOutside: false
                            }).then(function () {
                                location.reload();
                            });
                        }
                        else {
                            $('textarea#messageone').val('');
                            $('textarea#messageone').text('');
                            $('#message-popup').modal('toggle');
                        }
                    }
                });
            } else {
				$("#_error_").html('');
                $("#_error_").html('<div class="account-error">' + enter_message_content + '</div>');
				$("textarea#messageone").attr("style","border:1px solid red");
            }
            return false;
        } else {
            $("#_error_").text(please_select_users + '...');
            return false;
        }
    }

    function send_follow_request() {
        var profile_id = $('#profile_id').val();
        var user_id = $('#user_id').val();
        if (profile_id && user_id) {
            var form = $("#form_follow_request");
                var url = base_url + 'user/follow/save_follow';

                $.ajax({
                    url: url,
                    type: "POST",
                    data: form.serialize(),
                    /*dataType: 'json',*/
					cache: false,
                    success: function (res) {
                        location.reload();
                    }
                });

            return false;
        } else {
           
            return false;
        }
    }
	
    function get_all_new_chats_count(param) {
        var curr_url = $(location).attr('pathname');
        var expld = curr_url.split('/');
        var message_page = $('#message_page').val();

        if (message_page != 'true') {
            var url = base_url + 'user/chat/get_all_new_chats';
            $.ajax({
                url: url,
                dataType: 'json',

                cache: false,
                success: function (res) {
                    if (res.new_total > 0) {
                        $("#new_message_count").html(res.new_total);
                        $("#new_message_count").show();

                        var ts = '<div class="dropdown-menu notifications msg-noti" >';
                        ts += '<div class="topnav-dropdown-header"><span>' + messages + '</span></div>';
                        ts += '<div ><ul class="media-list scroll-content" id="new_chat_content">' + res.new_chats_content + '</ul></div>';
                        ts += '<div class="topnav-dropdown-footer"><a href="' + base_url + 'message">' + see_all_messages + '</a></div>';
                        ts += '</div>';
                        $("#message_notification").html(ts);
                    }
                }
            });
        }
    }
	
    function change_notification_status(id, sts, ele) {
        var url = base_url + 'user/notification/change_notification_status';
        $.ajax({
            type: 'post',
            url: url,
            data: { sts: sts, id: id },
            success: function (data) {
                if (data == 1) {
                    window.location.href = base_url + ele;
                }
            }
        });
    }

})(jQuery);