(function ($) {
	"use strict";
	$(document).ready(function() {
		$('#database_settings').bootstrapValidator({
			fields: {
				hostname: {
					validators: {
						notEmpty: {
							message: 'Please enter your hostname usually localhost'
						}
					}
				},
				db_name: {
					validators: {
						notEmpty: {
							message: 'Please specify your database name'
						}
					}
				},
				db_username: {
					validators: {
						notEmpty: {
							message: 'Please specify your database username'
						}
					}
				}
			}
		});
		$('#admin_basic_details').bootstrapValidator({
		fields: {
			base_url: {
				validators: {
					notEmpty: {
						message: 'Please enter the base url path '
					}
				}
			},
			admin_name: {
				validators: {
					notEmpty: {
						message: 'Please specify admin name'
					}
				}
			},
			admin_username: {
				validators: {
					notEmpty: {
						message: 'Please specify admin username'
					}
				}
			},
			admin_password: {
				validators: {
					notEmpty: {
						message: 'Please specify admin password'
					}
				}
			},
			admin_confirm_password: {
				validators: {
					notEmpty: {
						message: 'Please specify confirm password'
					},
					identical: {
						field: 'admin_password',
						message: 'The password and its confirm are not the same'
					}
				}
			},
			admin_email: {
				validators: {
					notEmpty: {
						message: 'Please specify admin email'
					}
				}
			}
		}
		});
	});
	$(document).ready(function() {
		$(".numonly").keydown(function(e) {
			if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 || (e.keyCode === 65 && (e.ctrlKey === true || e.metaKey === true)) || (e.keyCode >= 35 && e.keyCode <= 40)) {
				return;
			}
			if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
				e.preventDefault();
			}
		});
	});
})(jQuery);	