(function ($) {
	"use strict";
	var BASE_URL = $('#base_url').val();
	
	$(document).on('click', ".change_notification_alert", function() {
		var id=$(this).attr('data-id');
		var status=$(this).attr('data-status');
		var title=$(this).attr('data-title');
		change_notification_alert(id,status,title);
	});
	
	$('.delete_category').on('click', function () {
		var catid = $(this).attr('data-catid');
		delete_category(catid);
	});
	
	$('.delete_bgimage').on('click', function () {
		var bg_id = $(this).attr('data-bgid');
		delete_bgimage(bg_id);
	});
	$('.deleteadmin').on('click', function () {
		var adminid = $(this).attr('data-adminid');
		deleteadmin(adminid);
	});
	$('.section3icon').on('change', function () {
		var id = $(this,':selected').val();
        if(id=='Section3-Icon')
		{
		$('#bg_adimg').css('display','none');
		$('#allgigsimg').css('display','block');
		}
		else if(id!='Section3-Icon')
		{
		$('#bg_adimg').css('display','block');
		$('#allgigsimg').css('display','none');
		}

	});
	$('.delete_client').on('click', function () {
		var catid = $(this).attr('data-id');
		delete_client(catid);
	});
	
	$('.admin_delete_currency').on('click', function () {
		var id = $(this).attr('data-id');
		admin_delete_currency(id);
	});
	
	$('.delete_footer_menu').on('click', function () {
		var id = $(this).attr('data-id');
		delete_footer_menu(id);
	});
	
	$('.delete_footer_submenu').on('click', function () {
		var id = $(this).attr('data-id');
		delete_footer_submenu(id);
	});
	
	$('.admin_delete_gigs').on('click', function () {
		var id = $(this).attr('data-id');
		admin_delete_gigs(id);
	});
	
	$('.delete_language').on('click', function () {
		var id = $(this).attr('data-id');
		delete_language(id);
	}); 
	
	$('.delete_profession').on('click', function () {
		var id = $(this).attr('data-id');
		delete_profession(id);
	});
	
	$('.delete_policy_setting').on('click', function () {
		var id = $(this).attr('data-id');
		delete_policy_setting(id);
	});
	
	$('.delete_subscription').on('click', function () {
		var id = $(this).attr('data-id');
		delete_subscription(id);
	});
		$('.delete_faq_menu').on('click', function () {
		var faq_id = $(this).attr('data-id');
		//var id = $(this).attr('data-id');
		delete_faq_menu(faq_id);
	});

	$('.change_payments_status').on('click', function () {
		var item_id = $(this).attr('data-item_id');
		var id = $(this).attr('data-id');
		change_payments_status(item_id, id);
	});
	
	$('#ads_image, #client_image, #imageonly').change(function () {
		var url = $(this).val();
		var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
		if ((ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")) {
			$('#img_upload_error').css('display', 'none');
		}
		else {
			$('#img_upload_error').css('display', 'block');
			$('#ads_image').val('');
			$('#client_image').val('');
			$('#imageonly').val('');
		}
	});
	
	function release_payment(payment_id) {
		var url = BASE_URL + 'admin/release_payments/process_payment';
		$.ajax({
			type: 'POST',
			url: url,
			data: { payment_id: payment_id },
			success: function (response) {
				if (response == 1) {
					$('#row_id_' + payment_id).remove();
				}
			}
		})
	}
  
	function delete_seo_setting(seo_id) {
		var url = BASE_URL + 'admin/dashboard/delete_seo_setting';
		$.ajax({
			type: 'POST',
			url: url,
			data: { seo_id: seo_id },
			success: function (response) {
				if (response == 1) {
					location.reload();
					$('#row_id_' + seo_id).remove();
				}
			}
		})
	}

	$(document).ready(function () {
		$('.switch').on('switchChange.bootstrapSwitch', function (e, data) {
			var update_status = '';
			var sts_str = '';
			var gig_id = $(this).attr('id');
			var data_apprv=$(this).attr('data-approval');
			console.log(data_apprv);
			if(data_apprv==0)
			{
			if ($(this).is(':checked')) {
				update_status = '0';
				sts_str = 'Active';
			} else {
				update_status = '1';
				sts_str = 'InActive';
			}
			if (update_status != '') {
				$.ajax({
					type: 'POST',
					url: BASE_URL + 'admin/dashboard/update_gig_status',
					data: { gig_id: gig_id, update_status: update_status },
					success: function (response) {
						$('#change_staus_' + gig_id).html(sts_str);
					}
				});
			}
		}
		else if(data_apprv==1)
		{
				if ($(this).is(':checked')) {
				update_status = '1';
				sts_str = 'Active';
			} else {
				update_status = '0';
				sts_str = 'InActive';
			}
			if (update_status != '') {
				$.ajax({
					type: 'POST',
					url: BASE_URL + 'admin/dashboard/admin_autoapproval',
					data: { update_status: update_status },
					success: function (response) {
						$('#hidval').html(response);
						//alert(response);
					}
				});
			}
		}
		})
		
		$('#admin_add_profession').bootstrapValidator({
			fields: {
				profession: {
					message: 'The Menu name is not valid',
					validators: {
						notEmpty: {
							message: 'Please enter your Profession'
						},
						remote: {
							url: BASE_URL + 'admin/profession/check_profession',

							data: function (validator) {
								return {
									profession: validator.getFieldElements('profession').val()
								};
							},
							message: 'The Profession is already there !!!',
							type: 'POST'
						}
					}
				}
			}
		});

		$('#admin_add_subscription').bootstrapValidator({
			fields: {
				subscription_name: {
					message: 'The Menu name is not valid',
					validators: {
						notEmpty: {
							message: 'Please enter your Subscription Name'
						},
						remote: {
							url: BASE_URL + 'admin/subscription/check_subscription',

							data: function (validator) {
								return {
									subscription_name: validator.getFieldElements('subscription_name').val()
								};
							},
							message: 'The Subscription Name is already there !!!',
							type: 'POST'
						}
					}
				},

				subscription_period: {
					message: 'The Menu name is not valid',
					validators: {
						notEmpty: {
							message: 'Please enter your Subscription Period'
						},
					}
				},

				no_of_gigs: {
					message: 'The Menu name is not valid',
					validators: {
						notEmpty: {
							message: 'Please enter No of Gigs'
						},
					}
				},

				subscription_rate: {
					message: 'The Menu name is not valid',
					validators: {
						notEmpty: {
							message: 'Please enter Subscription Rate'
						},
						remote: {
							url: BASE_URL + 'admin/subscription/check_subscription_rate',

							data: function (validator) {
								return {
									subscription_rate: validator.getFieldElements('subscription_rate').val()
								};
							},
							message: 'Already Free version there !!!',
							type: 'POST'
						}
					}
				},
			}
		});

		$('#add_footer_menu').bootstrapValidator({
			fields: {
				menu_name: {
					message: 'The Menu name is not valid',
					validators: {
						remote: {
							url: BASE_URL + 'admin/dashboard/check_footer_menu',

							data: function (validator) {
								return {
									menu_name: validator.getFieldElements('menu_name').val()
								};
							},
							message: 'The Menu is already there !!!',
							type: 'POST'
						}
					}
				}
			}
		});

		$('#add_submenu').bootstrapValidator({
			fields: {
				menu_name: {
					message: 'The Menu name is not valid',
					validators: {
						remote: {
							url: BASE_URL + 'admin/dashboard/check_footer_submenu',
							data: function (validator) {
								return {
									menu_name: validator.getFieldElements('menu_name').val()
								};
							},
							message: 'The Menu is already there !!!',
							type: 'POST'
						}
					}
				},
				sub_menu: {
					validators: {
						notEmpty: {
							message: 'Please enter the sub_menu.'
						}
					}
				},
				page_title: {
					validators: {
						notEmpty: {
							message: 'Please enter the page_title.'
						}
					}
				},
				seo_title: {
					validators: {
						notEmpty: {
							message: 'Please enter the seo_title.'
						}
					}
				},
				ck_editor_textarea_id: {
					validators: {
						notEmpty: {
							message: 'Please enter the Page Description.'
						}
					}
				},
				seo_keyword: {
					validators: {
						notEmpty: {
							message: 'Please enter the seo_keyword.'
						}
					}
				},
				seo_desc: {
					validators: {
						notEmpty: {
							message: 'Please enter the seo_description.'
						}
					}
				}
			}
		});
		
		$('#admin_add_currency').bootstrapValidator({
			fields: {
				country_name: {
					validators: {
						notEmpty: {
							message: 'Please enter a Country Name'
						},
						remote: {
							url: BASE_URL + 'admin/currency/country_check',

							data: function (validator) {
								return {
									category_name: validator.getFieldElements('country_name').val(),
									id: $('#currency_id').val()
								};
							},
							message: 'The Country name is already there !!!',
							type: 'POST'
						}
					}
				}
			}
		});

		$('#admin_add_cat').bootstrapValidator({
			fields: {
				category_name: {
					validators: {
						notEmpty: {
							message: 'Please enter a Category'
						},
						remote: {
							url: BASE_URL + 'admin/dashboard/catagorycheck',

							data: function (validator) {
								return {
									category_name: validator.getFieldElements('category_name').val(),
									catagory_id: validator.getFieldElements('catagory_id').val()
								};
							},
							message: 'The Category name is already there !!!',
							type: 'POST'
						}
					}
				},
				category_image: {
					validators: {
						file: {
							extension: 'jpeg,png,jpg',
							type: 'image/jpeg,image/png,image/jpg',
							message: 'The selected file is not valid. Only allowed jpeg,jpg,png files'
						}
					}
				}

			}
		});

		$("#admin_add_client").on("submit", function (e) {
			e.preventDefault(); 
			var client_name = $('#client_name').val();
			var dgt = $("input[name='dgt[]']").val();
			var list_url = $('#list_url').val();
			if (client_name == "") {
				$('.client_error').text('Please enter a Client URL').css('color', '#a94442');
			}
			if (dgt == "") {
				$('.dgt_error').text('Please Select Image').css('color', '#a94442');
			}
			if (client_name == "" || dgt == "") {
				return false;
			}
			if (client_name != "" && dgt != "") {
				$.ajax({
					url: $("#admin_add_client").attr('action'),
					data: $("#admin_add_client").serialize(),
					type: "POST",
					dataType: "json",
					enctype: 'multipart/form-data',
					success: function (res) {
						if (res.status) {
							window.location.href = list_url;
						}
					}
				});
			}
		});

		$('#admin_edit_client').bootstrapValidator({
			fields: {
				client_name: {
					validators: {
						notEmpty: {
							message: 'Please enter a Client URL'
						}
					}
				}

			}
		});

		$('#admin_add_gigs').bootstrapValidator({
			fields: {
				default_gigs: {
					validators: {
						notEmpty: {
							message: 'Please enter a Desc'
						}
					}
				}
			}
		});

		$('#admin_add_ip').bootstrapValidator({
			fields: {
				ip_addr: {
					message: 'The IP Address is not valid',
					validators: {
						remote: {
							url: BASE_URL + 'admin/dashboard/check_existing_ip',
							data: function (validator) {
								return {
									ip_addr: validator.getFieldElements('ip_addr').val()
								};
							},
							message: 'The ip_addr is already banned',
							type: 'POST'
						}
					}
				}
			}
		});

		$('#admin_edit_ip').bootstrapValidator({
			fields: {
				ip_addr: {
					validators: {
						notEmpty: {
							message: 'Please enter a IP Address'
						}
					}
				}
			}
		});
		
		$('#form_emailsetting').bootstrapValidator({

			fields: {
				email_address: {
					validators: {
						notEmpty: {
							message: 'Please enter a Email'
						},
						emailAddress: {
							message: 'Please enter valid email address'
						}
					}
				},
				email_tittle: {
					validators: {
						notEmpty: {
							message: 'Please enter a Title'
						}
					}
				}

			}
		});

		$('#pass-val').bootstrapValidator({

			fields: {
				old_password: {
					validators: {
						notEmpty: {
							message: 'Please enter the old password'
						},
						remote: {
							url: BASE_URL + 'admin/dashboard/check_old_password',
							data: function (validator) {
								return {
									old_password: validator.getFieldElements('old_password').val()
								};
							},
							message: 'The Password is incorrect',
							type: 'POST'
						}
					}
				},
				new_password: {
					validators: {
						notEmpty: {
							field: 'new_password',
							message: 'Please enter the new password'
						},
						identical: {
							field: 'confirm_password',
							message: 'The confirm password and its new password are not the same'
						}
					}
				},
				confirm_password: {
					validators: {
						notEmpty: {
							field: 'new_password',
							message: 'Please enter the confirm_password'
						},
						identical: {
							field: 'new_password',
							message: 'The new password and its confirm are not the same'
						}
					}
				}
			}
		});
	});  

	function delete_footer_menu(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/footer_menu/delete_footer_menu';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/footer_menu';
						} else {
							window.location = BASE_URL + 'admin/footer_menu';
						}
					}
				});
			}
		});
	}

	function delete_policy_setting(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/policy_settings/delete';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/policy_settings';
						} else {
							window.location = BASE_URL + 'admin/policy_settings';
						}
					}
				});
			}
		});
	}

	function delete_footer_submenu(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/footer_submenu/delete_footer_submenu';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/footer_submenu';
						} else {
							window.location = BASE_URL + 'admin/footer_submenu';
						}
					}
				});
			}
		});
	}

	function delete_category(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/category/delete_category';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/category';
						}
					}
				});
			}
		});
	}
	
	function deleteadmin(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/adminlist/deleteadmin';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/adminlist';
						}
					}
				});
			}
		});
	}
	function delete_faq_menu(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/faq/delete_faq_menu';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/faq';
						}
					}
				});
			}
		});
	}
		function delete_bgimage(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/bgimage/delete_bgimage';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						//if (res == 1) {
							window.location = BASE_URL + 'admin/bgimage';
						//}
					}
				});
			}
		});
	}

	function delete_subscription(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/subscription/delete_subscription';
				var id = val;
				$.ajax({
					url: url,
					data: { id: id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/subscription';
						}
					}
				});
			}
		});
	}

	function delete_profession(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/profession/delete';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/profession';
						} else {
							window.location = BASE_URL + 'admin/profession';
						}
					}
				});
			}
		});
	}

	function delete_gigs(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/gigs/delete_gigs';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/gigs';
						}
					}
				});
			}
		});
	}

	function delete_page(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/static_page/delete_page';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/static_page';
						}
					}
				});
			}
		});
	}
	
	function delete_ip(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/ban_ip/delete_ip';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/ban_ip';
						}
					}
				});
			}
		});
	}
	
	function delete_request(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/request/delete_request';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/request';
						}
					}
				});
			}
		});
	}
	
	function delete_user(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/user/delete_user';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/user';
						}
					}
				});
			}
		});
	}

	function delete_ads(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/ads/delete';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/ads';
						}
					}
				});
			}
		});
	}

	function delete_review(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/review/delete';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/review';
						}
					}
				});
			}
		});
	}

	function delete_client(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/client/delete';
				var tbl_id = val;
				$.ajax({
					url: url,
					data: { tbl_id: tbl_id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/client';
						} else {
							window.location = BASE_URL + 'admin/client';
						}
					}
				});
			}
		});
	}

	$(document).ready(function () {
		setInterval(function () { get_notification_count() }, 20000);
		get_notification_count();
	});
	
	function get_notification_count() {
		var url = BASE_URL + 'admin/dashboard/get_all_notification';
		$.ajax({
			type: 'post',
			dataType: 'json',
			url: url,
			success: function (data) {
			if (data.payment_total > 0) {
				$("#payment_count").html(data.payment_total);
				var td = '<li class="notifi-title">Notification</li>';
				td += '<li class="list-group nicescroll notification-list">';
				td += data.payment_html;
				td += '</li>';
				$("#payment_alldata").html(td);
				} else {
					$("#payment_alldata").hide();
				}
				if (data.other_total > 0) {
					$("#notification_count").html(data.other_total);
					var td = '<li class="notifi-title">Notification</li>';
					td += '<li class="list-group nicescroll notification-list">';
					td += data.other_html;
					td += '</li>';
					$("#notification_alldata").html(td);
				} else {
					$("#notification_alldata").hide();
				}
			}
		});
	}
	
	function change_notification_alert(id, sts, ele) {
		var url = BASE_URL + 'admin/dashboard/change_notification_alert';
		$.ajax({
			type: 'post',
			url: url,
			data: { sts: sts, id: id },
			success: function (data) {
				if (data == 1) {
					if (sts == 'new_gig') {
						window.location.href = BASE_URL + 'admin/gigs';
					}
					else {
						window.location.href = BASE_URL + 'admin/release_payments';
					}
				}
			}
		});
	}
  
	function release_payment_admin(id, ele) {
		bootbox.confirm("Are you sure want to UPDATE ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/request/update_payment_status';
				$.ajax({
					url: url,
					data: { id: id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							$("#" + ele).removeAttr("onclick");
							$("#" + ele).html('Transfer Completed');
						}
					}
				});
			}
		});
	}
  
	function change_payments_status(id, ele) {
		bootbox.confirm("Are you sure want to UPDATE ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/request/update_payment_status';
				$.ajax({
					url: url,
					data: { id: id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							$("#" + ele).html('<span class="label label-success">Transfer Completed</span>');
						}
					}
				});
			}
		});
	}
  
	function admin_delete_currency(id) {
		if (confirm("Are you sure you want to delete this Currency?")) {
			$.post(BASE_URL + 'admin/currency/admin_delete_currency', { id: id }, function (result) {
				if (result) {
					location.reload();
				}
			});
		}
	}
  
	function admin_delete_gigs(id) {
		if (confirm("Are you sure you want ot delete this Gig?")) {
			$.post(BASE_URL + 'admin/admin_delete_gigs', { id: id }, function (result) {
				if (result) {
					location.reload();
				}
			});
		}
	}

	function multiple_keyword_validation() {
		var error = 0;
		var keyword = $('#multiple').val().trim();

		if (keyword == "") {
			$('.multi_keyword_error').show();
			error = 1;
		} else {
			$('.multi_keyword_error').hide();
		}
		if (error == 0) {
			return true;
		} else {
			return false;
		}
	}

	function delete_language(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/language_management_controller/delete_keyword';
				var id = val;
				$.ajax({
					url: url,
					data: { id: id },
					type: "POST",
					success: function (res) {
						if (res == 1) {
							window.location = BASE_URL + 'admin/language_management_controller/add_keyword';
						}
					}
				});
			}
		});
	}

	$('#app_keyword_validation').bootstrapValidator({
		message: 'This value is not valid',
		feedbackIcons: {
			valid: 'glyphicon glyphicon-ok',
			invalid: 'glyphicon glyphicon-remove',
			validating: 'glyphicon glyphicon-refresh'
		},
		fields: {
			page_name: {
				message: 'Please enter a page name',
				validators: {
					notEmpty: {
						message: 'Please enter a page name'
					}
				}
			}
		}
	});

	$('#language_validation').bootstrapValidator({
		message: 'This value is not valid',
		feedbackIcons: {
			valid: 'glyphicon glyphicon-ok',
			invalid: 'glyphicon glyphicon-remove',
			validating: 'glyphicon glyphicon-refresh'
		},
		fields: {
			language: {
				message: 'Please enter a language',
				validators: {
					notEmpty: {
						message: 'Please enter a language'
					}
				}
			}, value: {
				message: 'Please enter a value',
				validators: {
					notEmpty: {
						message: 'Please enter a value'
					}
				}
			}, flag: {
				message: 'Please Select Flag',
					validators: {
					notEmpty: {
						message: 'Please Select Flag'
					}
				}
			}

		}
	});
  
	$('#add_keyword_validations').bootstrapValidator({
		message: 'This value is not valid',
		feedbackIcons: {
			valid: 'glyphicon glyphicon-ok',
			invalid: 'glyphicon glyphicon-remove',
			validating: 'glyphicon glyphicon-refresh'
		},
		fields: {
			field_name: {
				message: 'Please enter a field',
				validators: {
					notEmpty: {
						message: 'Please enter a field'
					}
				}
			}, name: {
				message: 'Please enter a name',
				validators: {
					notEmpty: {
						message: 'Please enter a name'
					}
				}
			}
		}
	});

	function delete_language(val) {
		bootbox.confirm("Are you sure want to Delete ? ", function (result) {
			if (result == true) {
				var url = BASE_URL + 'admin/language/delete_language';
				var id = val;
				$.ajax({
					url: url,
					data: { id: id },
					type: "POST",
					dataType: "json",
					success: function (res) {
						if (res.status) {
							window.location = BASE_URL + 'admin/language/languages';
						}
					}
				});
			}
		});
	}
	
})(jQuery);