<?php
$payment_stripe = 0;
$payment_paypal = 0;
$payment_paytabs = 0;
if (!empty($system_setting)) {
	foreach ($system_setting as $system) {
		if ($system['key'] == 'stripe_allow') {
			$payment_stripe = $system['value'];
		}
		if ($system['key'] == 'paypal_allow') {
			$payment_paypal = $system['value'];
		}
		if ($system['key'] == 'paytabs_allow') {
			$payment_paytabs = $system['value'];
		}
	}
}
?>
<section class="buy-service" id="">
	<div class="header-bottom">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-6 col-xs-12 col-sm-6">
					<ul class="breadcrumb">
						<li><a href="<?php echo base_url(); ?>"><?php echo (!empty($user_language[$user_selected]['lg_home'])) ? $user_language[$user_selected]['lg_home'] : $default_language['en']['lg_home']; ?></a></li>
						<?php
						$login_user_id = $this->session->userdata('SESSION_USER_ID');
						if ($profile['USERID'] == $login_user_id) { ?>
							<li><?php echo (!empty($user_language[$user_selected]['lg_my_profile'])) ? $user_language[$user_selected]['lg_my_profile'] : $default_language['en']['lg_my_profile']; ?></li>
						<?php } else { ?>
							<li> <?php echo (!empty($user_language[$user_selected]['lg_profile'])) ? $user_language[$user_selected]['lg_profile'] : $default_language['en']['lg_profile']; ?></li>
						<?php } ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="myprofile-section">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12 col-sm-12">
				<div class="profile-rht myprofile-tab">
					<ul class="nav nav-tabs tabs-left">
						<li>
							<a href="<?php echo base_url() . 'purchases'; ?>">
								<span class="visible-xxs"><i class="fa fa-shopping-bag" aria-hidden="true"></i></span>
								<span class="hidden-xxs"><span class="text-blk"><?php echo (!empty($user_language[$user_selected]['lg_my_purchases'])) ? $user_language[$user_selected]['lg_my_purchases'] : $default_language['en']['lg_my_purchases']; ?> </span> <?php if ($order_count > 0) { ?><span class="badge badge-white position-right"><?php echo $order_count; ?></span><?php } ?></span>
							</a>
						</li>
						<li>
							<a href="<?php echo base_url() . 'sales'; ?>">
								<span class="visible-xxs"><i class="fa fa-shopping-basket" aria-hidden="true"></i> </span>
								<span class="hidden-xxs"><span class="text-blk"><?php echo (!empty($user_language[$user_selected]['lg_my_sales'])) ? $user_language[$user_selected]['lg_my_sales'] : $default_language['en']['lg_my_sales']; ?> </span> <?php if ($sell_order_count > 0) { ?><span class="badge badge-white position-right"><?php echo $sell_order_count; ?></span><?php } ?></span>
							</a>
						</li>
						<li class="active">
							<a href="javascript:;">
								<span class="visible-xxs"><i class="fa fa-cc-paypal" aria-hidden="true"></i> </span>
								<span class="hidden-xxs"><span class="text-blk"><?php echo (!empty($user_language[$user_selected]['lg_my_payments'])) ? $user_language[$user_selected]['lg_my_payments'] : $default_language['en']['lg_my_payments']; ?> </span> <?php if ($wallet_order_count > 0) { ?><span class="badge badge-white position-right"><?php echo $wallet_order_count; ?></span><?php } ?></span>
							</a>
						</li>
						<li>
							<a href="<?php echo base_url() . 'files'; ?>">
								<span class="visible-xxs"><i class="fa fa-file-text" aria-hidden="true"></i></span>
								<span class="hidden-xxs text-blk"><?php echo (!empty($user_language[$user_selected]['lg_my_files'])) ? $user_language[$user_selected]['lg_my_files'] : $default_language['en']['lg_my_files']; ?></span>
							</a>
						</li>
					</ul>
				</div>
				<div class="tab-content">
					<div class="tab-pane active" id="Payments" role="tabpanel" aria-labelledby="nav-contact-tab">
						<form method="post" autocomplete="off" action="<?php echo base_url(); ?>payments">
							<div class="my-purchase-01">
								<div class="form-group ct-form-one">
									<div class="mt20px">
										<input type="text" class="mt10px" id="J-demo-01" name="fromdate" placeholder="<?php echo (!empty($user_language[$user_selected]['lg_from_date'])) ? $user_language[$user_selected]['lg_from_date'] : $default_language['en']['lg_from_date']; ?>">
									</div>
								</div>
								<div class="form-group ct-form-two">
									<div class="mt20px">
										<input type="text" class="mt10px" id="J-demo-02" placeholder="<?php echo (!empty($user_language[$user_selected]['lg_to_date'])) ? $user_language[$user_selected]['lg_to_date'] : $default_language['en']['lg_to_date']; ?>" name="todate">
									</div>
								</div>
								<div class="form-group ct-form-four">
									<button name="form_submit" class="ct-form-search" value="search" type="submit"><i class="fa fa-search" aria-hidden="true"></i></button>
									<a href="<?= base_url() . 'payments'; ?>"><button class="ct-form-reset refresh_form_payment" name="form_submit" value="true" type="reset"><i class="fa fa-refresh" aria-hidden="true"></i></button></a>
									<button name="form_submit" class="ct-form-pdf" value="pdf" type="submit"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></button>
								</div>
							</div>
						</form>
						<!-- 3rd tab start -->
						<div class="my-purchase-list my-payments">
							<div class="row mb20">
								<div class="col-md-12 ">
									<?php
									$country_name = $this->session->userdata('country_name');
									$rupee_rate  = $this->session->userdata('rupee_rate');
									$dollar_rate = $this->session->userdata('dollar_rate');
									$t_amount = 0;
									$tl_amount = 0;
									$total_amount = 0;
									$total_amount1 = 0;
									$rate_symbol = '';
									$all_sources = array();
									$user_currency = get_user_currency();
									$user_currency_code = $user_currency['user_currency_code'];
									$user_currency_rate = $user_currency['user_currency_rate'];
									$request_entire_amount = 0;
									if (!empty($order_details)) {
										foreach ($order_details as $item_am) {
											$all_sources[] = $item_am['source'];
											if ($item_am['payment_status'] != 2) {
												$c_amounts = $item_am['item_amount'];
												$commision_rate = (($c_amounts * $item_am['commision']) / 100);
												$comision_referido = $item_am['comision_referido'];
												$c_amount = $c_amounts - $commision_rate - $comision_referido;
												$t_amount = $c_amount;
												$dollar_amount = $item_am['dollar_amount'];
												$t_amount = $c_amount;
												$currency_option = (!empty($user_currency_code)) ? $user_currency_code : 'USD';
												$rate_symbol = currency_conversion($currency_option);
												$total_amount += get_gigs_currency($t_amount, $item_am['currency_type'], $user_currency_code);
											}
											if ($item_am['payment_status'] == 0) {
												$cls_amount = $item_am['item_amount'];
												$commision_rates = (($cls_amount * $item_am['commision']) / 100);
												$comision_referido = $item_am['comision_referido'];
												$cl_amount = $c_amounts - $commision_rates - $comision_referido;
												$dl_amount = $item_am['dollar_amount'];
												$tl_amount = $cl_amount;
												$currency_option = (!empty($user_currency_code)) ? $user_currency_code : 'USD';
												$rate_symbol = currency_conversion($currency_option);
												$tl_amount = $tl_amount;
												$total_amount1 += $tl_amount;
												$request_entire_amount += $tl_amount;
											}
										}
									} ?>
									<h4><?php echo (!empty($user_language[$user_selected]['lg_current_balance'])) ? $user_language[$user_selected]['lg_current_balance'] : $default_language['en']['lg_current_balance']; ?>: <?php echo $rate_symbol; ?><?php echo $total_amount; ?></h4>
									<?php if ($total_amount1 > 0) {
										$all_sources = array_unique($all_sources);
										$asc = count($all_sources);
									?>
								</div>
								<div class="col-md-6 text-right">
									<a href="javascript:;" data-sources="<?php echo implode('-', $all_sources); ?>" data-asc="<?php echo $asc; ?>" class="withdraw_all_sources btn btn-primary btn-border text-uppercase bold withdraw_all"><?php echo (!empty($user_language[$user_selected]['lg_request_entire_amount'])) ? $user_language[$user_selected]['lg_request_entire_amount'] : $default_language['en']['lg_request_entire_amount']; ?></a>
								</div>
							</div>
						<?php } ?>
						<div class="row">
							<div class="col-md-12">
								<div class="table-responsive order-table">
									<table class="table table-striped ">
										<thead>
											<tr class="thead-tr">
												<th><?php echo (!empty($user_language[$user_selected]['lg_order_date'])) ? $user_language[$user_selected]['lg_order_date'] : $default_language['en']['lg_order_date']; ?></th>
												<th><?php echo (!empty($user_language[$user_selected]['lg_order_id'])) ? $user_language[$user_selected]['lg_order_id'] : $default_language['en']['lg_order_id']; ?></th>
												<th><?php echo (!empty($user_language[$user_selected]['lg_buyer'])) ? $user_language[$user_selected]['lg_buyer'] : $default_language['en']['lg_buyer']; ?></th>
												<th><?php echo (!empty($user_language[$user_selected]['lg_payments'])) ? $user_language[$user_selected]['lg_payments'] : $default_language['en']['lg_payments']; ?></th>
												<th><?php echo (!empty($user_language[$user_selected]['lg_amount'])) ? $user_language[$user_selected]['lg_amount'] : $default_language['en']['lg_amount']; ?></th>
											</tr>
										</thead>
										<tbody>
											<?php
											if (!empty($order_details)) {
												$country_name = $this->session->userdata('country_name');
												$rupee_rate  = $this->session->userdata('rupee_rate');
												$dollar_rate  = $this->session->userdata('dollar_rate');
												$user_currency = get_user_currency();
												$user_currency_code = $user_currency['user_currency_code'];
												$user_currency_rate = $user_currency['user_currency_rate'];
												foreach ($order_details as $item) {
													$source = $item['source'];
													$seller_id = $item['seller_id'];
													$currency_option = (!empty($user_currency_code)) ? $user_currency_code : 'USD';
													$rate_symbol = currency_conversion($currency_option);
													$rates = get_gigs_currency($item['item_amount'], $item['currency_type'], $user_currency['user_currency_code']);
													$request_sent =  (!empty($user_language[$user_selected]['lg_request_sent'])) ? $user_language[$user_selected]['lg_request_sent'] : $default_language['en']['lg_request_sent'];
													$payment_received =  (!empty($user_language[$user_selected]['lg_payment_received'])) ? $user_language[$user_selected]['lg_payment_received'] : $default_language['en']['lg_payment_received'];
													$withdraw_amount =  (!empty($user_language[$user_selected]['lg_withdraw_amount'])) ? $user_language[$user_selected]['lg_withdraw_amount'] : $default_language['en']['lg_withdraw_amount'];
													$commision_rate = (($rates * $item['commision']) / 100);
													$comision_referido = $item['comision_referido'];
													$rate = $rates - $commision_rate - $comision_referido;
													$rate = number_format((float)$rate, 2, '.', '');
													$f_uid = $item['user_id'];
													$t_uid = $item['USERID'];
													$gid   = $item['gigs_id'];
													$id    = $item['id'];
													$status = $item['payment_status'];
													if ($status == 1) {
														$sts = '<b class="text-danger">' . $request_sent . '</b>';
													} elseif ($status == 2) {
														$sts = '<b class="text-success">' . $payment_received . '</b>';
													} else {
														$single = "'";
														$sts = '<a href="javascript:;" data-id="' . $id . '" data-source="' . $single . $source . $single . '" data-seller_id="' . $seller_id . '" class="btn btn-primary btn-border btn-sm withdram_model">' . $withdraw_amount . '</a>';
													}
													$created_on = '-';
													if (isset($item['created_at'])) {
														if (!empty($item['created_at']) && $item['created_at'] != "0000-00-00 00:00:00") {
															$created_on = date('j F Y g:i', strtotime($item['created_at']));
														}
													}
													if ($item['gig_image_thumb'] != '') {
														$image_url = base_url() . $item['gig_image_thumb'];
													} else {
														$image_url = 'assets/img/gig-small.jpg';
													}
													$user_linkone = base_url() . 'user-profile/' . $item['username'];
											?>
											<tr class="tbody-tr">
												<td>
													<div class="product-group">
														<div class="pro_img">
															<a href="javascript:;" class="wallets_view" data-id="<?php echo $item['id']; ?>"><img src="<?php echo $image_url; ?>" alt="" width="50" height="34"></a>
														</div>
														<div class="pro_con">
															<h4 class="product-name2"><a href="javascript:;" class="wallets_view" data-id="<?php echo $item['id']; ?>"><?php echo ucfirst(str_replace("-", " ", $item['title'])); ?></a></h4>
															<span class="order_date"><?php echo $created_on; ?></span>
														</div>
													</div>
												</td>
												<td>
													<a href="javascript:;" class="wallets_view" data-id="<?php echo $item['id']; ?>"><?php echo $item['id']; ?></a>
												</td>
												<td>
													<a href="<?php echo $user_linkone; ?>" class="text-dark"><b><?php echo ucfirst($item['fullname']); ?></b></a>
												</td>
												<td>
													<?php echo $sts; ?>
												</td>
												<td><?php echo $rate_symbol . $rate; ?></td>
											</tr>
											<?php
											}
											} else { ?>
												<tr>
													<td colspan="5">
														<p class="text-center text-danger m-b-0"><?php echo (!empty($user_language[$user_selected]['lg_no_records_found'])) ? $user_language[$user_selected]['lg_no_records_found'] : $default_language['en']['lg_no_records_found']; ?></p>
													</td>
												</tr>
											<?php } ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
						</div>
						<!-- 3rd tab end -->
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="bottom-pagination">
					<ul class="pagination pagination-sm">
						<li><?php echo $links; ?></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>

<div id="purchase-popup" class="modal fade custom-popup order-popup" role="dialog">
	<div class="modal-dialog custom-modal-size">
		<div class="modal-content" id="purchases_model_deatils"></div>
	</div>
</div>

<div id="message-popup" class="modal fade custom-popup" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<div class="modal-body">
				<div class="msg-user-details" id="msg-user-details"></div>
				<div class="new-message">
					<div id="_error_"></div>
					<form id="form_messagecontent_id" method="post" enctype="multipart/form-data">
						<input type="hidden" name="sell_gigs_userid" id="sell_gigs_userid" value="" />
						<div class="form-group">
							<label class="form-label"><?php echo (!empty($user_language[$user_selected]['lg_your_message'])) ? $user_language[$user_selected]['lg_your_message'] : $default_language['en']['lg_your_message']; ?></label>
							<textarea name="chat_message_content" placeholder="Message" required="" id="messageone" class="form-control"></textarea>
						</div>
					</form>
				</div>
				<button type="submit" name="submit" class="btn btn-primary btn-style save_newchat"><?php echo (!empty($user_language[$user_selected]['lg_send'])) ? $user_language[$user_selected]['lg_send'] : $default_language['en']['lg_send']; ?></button>
			</div>
		</div>
	</div>
</div>
</div>

<div id="withdraw-popup" class="modal fade custom-popup grey-popup" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<div class="modal-header text-center">
				<h5><?php echo (!empty($user_language[$user_selected]['lg_withdraw_amount'])) ? $user_language[$user_selected]['lg_withdraw_amount'] : $default_language['en']['lg_withdraw_amount']; ?></h5>
			</div>
			<div class="modal-body">
				<div class="table-responsive" id="wallets_gigs_details"></div>
				<div class="row">
					<div class="col-md-12">
						<div class="withdraw-amount">
							<span class="unit-price"><?php echo (!empty($user_language[$user_selected]['lg_requested_amount'])) ? $user_language[$user_selected]['lg_requested_amount'] : $default_language['en']['lg_requested_amount']; ?> :</span><span class="price-tag"><?php echo $rate_symbol ?></span><span class="price-tag" id="wallets_request_amount"></span>
						</div>
					</div>
				</div>
				<div class="withdraw-btn">
					<input type="hidden" name="request_payment_id" id="request_payment_id" value="" />
					<button type="button" class="btn btn-primary btn-border payment_request"><?php echo (!empty($user_language[$user_selected]['lg_request_withdraw'])) ? $user_language[$user_selected]['lg_request_withdraw'] : $default_language['en']['lg_request_withdraw']; ?></button>
				</div>
			</div>
			<div class="modal-footer text-left">
				<div class="media secure-money">
					<div class="media-left">
						<img width="46" height="40" src="assets/img/secure-money.png" alt="">
					</div>
					<div class="media-body">
						<span><?php echo (!empty($user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'])) ? $user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'] : $default_language['en']['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion']; ?>.</span>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div id="withdraw-redirect-popup" class="modal fade custom-popup grey-popup" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<div class="modal-header text-center">
				<h5><?php echo (!empty($user_language[$user_selected]['lg_withdraw_amount'])) ? $user_language[$user_selected]['lg_withdraw_amount'] : $default_language['en']['lg_withdraw_amount']; ?></h5>
			</div>
			<div class="modal-body">
				<div class="table-responsive" id="wallets_gigs_details"></div>
				<div id="payment-method">
					<div class="alert alert-danger text-center">
						<strong><?php echo (!empty($user_language[$user_selected]['lg_are_you_sure_request_entire_amount'])) ? $user_language[$user_selected]['lg_are_you_sure_request_entire_amount'] : $default_language['en']['lg_are_you_sure_request_entire_amount']; ?> <?php echo $rate_symbol; ?><?php echo $request_entire_amount; ?>.<br />
						</strong>
					</div>
					<div class="text-center"><a href="javascript:void(0)" data-id="paypal-stripe" class="btn btn-primary user_paypal_submit"><?php echo (!empty($user_language[$user_selected]['lg_accept'])) ? $user_language[$user_selected]['lg_accept'] : $default_language['en']['lg_accept']; ?></a></div>
				</div>
			</div>
			<div class="modal-footer text-left">
				<div class="media secure-money">
					<div class="media-left">
						<img width="46" height="40" src="assets/img/secure-money.png" alt="">
					</div>
					<div class="media-body">
						<span><?php echo (!empty($user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'])) ? $user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'] : $default_language['en']['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion']; ?>.</span>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div id="paypal-popup" class="modal fade custom-popup" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<div class="modal-header text-center">
				<h4 class="sign-title"><?php echo (!empty($user_language[$user_selected]['lg_add_account_details'])) ? $user_language[$user_selected]['lg_add_account_details'] : $default_language['en']['lg_add_account_details']; ?></h4>
			</div>
			<div class="modal-body">
				<form class="form-horizontal" id="bank_details_form">
					<div class="error_msg text-center" id="paypal_errormsg"></div>
					<div class="form-group paypal_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_paypal_email_id'])) ? $user_language[$user_selected]['lg_paypal_email_id'] : $default_language['en']['lg_paypal_email_id']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="user_paypal_id" name="user_paypal_id" class="form-control paypal_input">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_the_account_holders_name'])) ? $user_language[$user_selected]['lg_the_account_holders_name'] : $default_language['en']['lg_the_account_holders_name']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="account_holder_name" name="account_holder_name" class="form-control stripe_input only_alphabets">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_account_number'])) ? $user_language[$user_selected]['lg_account_number'] : $default_language['en']['lg_account_number']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="account_number" name="account_number" class="form-control stripe_input  only_numeric">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_iban'])) ? $user_language[$user_selected]['lg_iban'] : $default_language['en']['lg_iban']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="account_iban" name="account_iban" class="form-control stripe_input IsAlphaNumeric ondrop onpaste">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_bank_name'])) ? $user_language[$user_selected]['lg_bank_name'] : $default_language['en']['lg_bank_name']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="bank_name" name="bank_name" class="form-control stripe_input  only_alphabets">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_bank_address'])) ? $user_language[$user_selected]['lg_bank_address'] : $default_language['en']['lg_bank_address']; ?></label>
						<div class="col-lg-8">
							<input type="text" id="bank_address" name="bank_address" class="form-control stripe_input">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_sort_code'])) ? $user_language[$user_selected]['lg_sort_code'] : $default_language['en']['lg_sort_code']; ?>(<?php echo (!empty($user_language[$user_selected]['lg_uk'])) ? $user_language[$user_selected]['lg_uk'] : $default_language['en']['lg_uk']; ?>)</label>
						<div class="col-lg-8">
							<input type="text" id="sort_code" name="sort_code" class="form-control stripe_input only_numeric" placeholder="<?php echo (!empty($user_language[$user_selected]['lg_uk_bank_code'])) ? $user_language[$user_selected]['lg_uk_bank_code'] : $default_language['en']['lg_uk_bank_code']; ?> (<?php echo (!empty($user_language[$user_selected]['lg_6_digits_usually_displayed_as_3_pairs_of_numbers'])) ? $user_language[$user_selected]['lg_6_digits_usually_displayed_as_3_pairs_of_numbers'] : $default_language['en']['lg_6_digits_usually_displayed_as_3_pairs_of_numbers']; ?>)">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_routing_number'])) ? $user_language[$user_selected]['lg_routing_number'] : $default_language['en']['lg_routing_number']; ?>(<?php echo (!empty($user_language[$user_selected]['lg_us'])) ? $user_language[$user_selected]['lg_us'] : $default_language['en']['lg_us']; ?>)</label>
						<div class="col-lg-8">
							<input type="text" id="routing_number" name="routing_number" class="form-control stripe_input only_numeric" placeholder="<?php echo (!empty($user_language[$user_selected]['lg_the_american_bankers_association_number'])) ? $user_language[$user_selected]['lg_the_american_bankers_association_number'] : $default_language['en']['lg_the_american_bankers_association_number']; ?> (<?php echo (!empty($user_language[$user_selected]['lg_consists_of_9_digits'])) ? $user_language[$user_selected]['lg_consists_of_9_digits'] : $default_language['en']['lg_consists_of_9_digits']; ?>) <?php echo (!empty($user_language[$user_selected]['lg_and_is_also_called_a_aba_routing_number'])) ? $user_language[$user_selected]['lg_and_is_also_called_a_aba_routing_number'] : $default_language['en']['lg_and_is_also_called_a_aba_routing_number']; ?>">
						</div>
					</div>
					<div class="form-group stripe_input_content">
						<label class="col-lg-4"><?php echo (!empty($user_language[$user_selected]['lg_ifsc_code'])) ? $user_language[$user_selected]['lg_ifsc_code'] : $default_language['en']['lg_ifsc_code']; ?>(<?php echo (!empty($user_language[$user_selected]['lg_indian'])) ? $user_language[$user_selected]['lg_indian'] : $default_language['en']['lg_indian']; ?>)</label>
						<div class="col-lg-8">
							<input type="text" id="account_ifsc" name="account_ifsc" class="form-control stripe_input IsAlphaNumeric ondrop onpaste" placeholder="<?php echo (!empty($user_language[$user_selected]['lg_financial_system_code'])) ? $user_language[$user_selected]['lg_financial_system_code'] : $default_language['en']['lg_financial_system_code']; ?>, <?php echo (!empty($user_language[$user_selected]['lg_which_is_a_unique_11'])) ? $user_language[$user_selected]['lg_which_is_a_unique_11'] : $default_language['en']['lg_which_is_a_unique_11']; ?>-<?php echo (!empty($user_language[$user_selected]['lg_digit_code_that_identifies_the_bank_branch'])) ? $user_language[$user_selected]['lg_digit_code_that_identifies_the_bank_branch'] : $default_language['en']['lg_digit_code_that_identifies_the_bank_branch']; ?> i.e. <?php echo (!empty($user_language[$user_selected]['lg_icic0001245'])) ? $user_language[$user_selected]['lg_icic0001245'] : $default_language['en']['lg_icic0001245']; ?>">
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-6 stripe_input_content">
							<p class="text-danger error_note"></p>
						</div>
						<div class="col-lg-6"><button type="button" data-id="1" id="payment_btn" class="btn btn-primary logon-btn pull-right user_paypal_submit"><?php echo (!empty($user_language[$user_selected]['lg_save'])) ? $user_language[$user_selected]['lg_save'] : $default_language['en']['lg_save']; ?></button></div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<div id="withdraw-all" class="modal fade custom-popup grey-popup" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<div class="modal-header text-center">
				<h5><?php echo (!empty($user_language[$user_selected]['lg_withdraw_amount'])) ? $user_language[$user_selected]['lg_withdraw_amount'] : $default_language['en']['lg_withdraw_amount']; ?></h5>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div class="withdraw-amount">
							<?php
							$tot_amount = 0;
							$pay_throught = '';
							if (!empty($order_details)) {
								foreach ($order_details as $item_am) {
									if ($item_am['payment_status'] == 0) {
										$c_amount = $item_am['item_amount'];
										$pay_throught = strtolower($item_am['source']);
										$tot_amount = $tot_amount + $c_amount;
									}
								}
							} ?>
							<span class="unit-price"><?php echo (!empty($user_language[$user_selected]['lg_available_balance'])) ? $user_language[$user_selected]['lg_available_balance'] : $default_language['en']['lg_available_balance']; ?> :</span> <span class="price-tag"><?php echo $rate_symbol . $total_amount1; ?></span>
						</div>
					</div>
				</div>
				<form>
					<div id="payment-method">
						<h4 class="clearfix"><?php echo (!empty($user_language[$user_selected]['lg_select_your_payment_method'])) ? $user_language[$user_selected]['lg_select_your_payment_method'] : $default_language['en']['lg_select_your_payment_method']; ?></h4>
						<div class="payment-method">
							<div class="gigs-form-01">
								<?php if ($payment_paypal == 1) { ?>
								<span>
									<input type="radio" value="0" id="payment_radio3" name="group2">
									<label for="payment_radio3"><img src="assets/img/paypal-icon.png" alt="Paypal"><?php echo (!empty($user_language[$user_selected]['lg_paypal'])) ? $user_language[$user_selected]['lg_paypal'] : $default_language['en']['lg_paypal']; ?></label>
								</span>
								<?php } ?>
								<?php if ($payment_paytabs == 1) { ?>
								<span>
									<input type="radio" value="1" id="payment_radio4" name="group2">
									<label for="payment_radio4"><?php echo (!empty($user_language[$user_selected]['lg_pay_tabs'])) ? $user_language[$user_selected]['lg_pay_tabs'] : $default_language['en']['lg_pay_tabs']; ?></label> </label>
								</span>
								<?php } ?>
								<?php if ($payment_stripe == 1) { ?>
								<span>
									<input type="radio" value="2" id="payment_radio5" name="group2">
									<label for="payment_radio5"><?php echo (!empty($user_language[$user_selected]['lg_stripe'])) ? $user_language[$user_selected]['lg_stripe'] : $default_language['en']['lg_stripe']; ?></label>
								</span>
								<?php } ?>
							</div>
						</div>
					</div>
					<div>
						<button type="button" class="btn btn-primary btn-border overall_payment_request">Request <?php echo (!empty($user_language[$user_selected]['lg_request_withdraw'])) ? $user_language[$user_selected]['lg_request_withdraw'] : $default_language['en']['lg_request_withdraw']; ?></button>
					</div>
				</form>
			</div>
			<div class="modal-footer text-left">
				<div class="media secure-money">
					<div class="media-left">
						<img width="46" height="40" src="assets/img/secure-money.png" alt="">
					</div>
					<div class="media-body">
						<span><?php echo (!empty($user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'])) ? $user_language[$user_selected]['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion'] : $default_language['en']['lg_your_deposit_will_be_securely_held_in_escrow_until_you_are_happy_to_release_it_to_the_seller_upon_hourlie_completion']; ?>.</span>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>