<div class="content-page">
	<div class="content">
		<div class="container">
			<div class="row">
				<div class="col-sm-8">
					<h4 class="page-title m-t-0">New Updates</h4>
				</div>
				<div class="pull-right">
					<button class="btn btn-primary" id="upload"><i class="fa fa-upload m-r-5"></i> Upload</button>
					<button class="btn btn-danger" id="check"><i class="fa fa-refresh m-r-5"></i> Check Updates</button><button class="btn btn-success hidden" id="download"><i class="fa fa-download m-r-5"></i> New updates available</button>
					<input type="hidden" name="filename" id="filename">
				</div>
			</div>
			<div class="clear-fix"></div><br>
			<form id="upload_form" enctype="multipart/form-data">
				<input type="file" name="upload_file" id="upload_file" class="hidden">
			</form>
			<div class="notify"></div>
			<?php
			if ($this->session->flashdata('message')) {
			?>
			<div class="alert alert-danger fade in alert-dismissable">
				<a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
				<strong><?php echo $this->session->flashdata('message'); ?></strong>
			</div>
			<?php
			} elseif ($this->session->flashdata('success')) {
			?>
			<div class="alert alert-success fade in alert-dismissable">
				<a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
				<strong>Success ! </strong><?php echo $this->session->flashdata('success'); ?>
			</div>
			<?php
			}
			?>
			<div class="panel">
				<div class="panel-body">
					<div class="table-responsive">
						<table class="table table-striped table-actions-bar datatable">
							<thead>
								<tr>
									<th>#</th>
									<th>Build</th>
									<th>Version</th>
									<th>Title</th>
									<th>Last Updated On</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$i = 1;
								foreach ($updates as $u) {
								?>
								<tr>
									<td><?php echo $i++; ?></td>
									<td><?php echo $u->build; ?></td>
									<td><?php echo $u->version; ?></td>
									<td><?php echo $u->title; ?></td>
									<td><?php echo date('d-m-Y H:i A', strtotime($u->last_updated)); ?></td>
								</tr>
								<?php
								}
								?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<br>
			<div class="backups">
				<div class="row">
					<div class="col-sm-8">
						<h4 class="page-title m-b-20 m-t-0">Backup Details</h4>
					</div>
					<div class="col-sm-4 text-right m-b-20">
						<a class="btn btn-success pull-right backup_btn" href="<?php echo  base_url(); ?>admin/new_updates/backup_db"><i class="fa fa-database m-r-5"></i> Backup Files & DB</a>
						<button class="btn btn-info pull-right loading hidden"><i class="fa fa-spinner fa-spin fa-fw m-r-5"></i> Please wait backup on process</button>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
			<div class="panel">
				<div class="panel-body">
					<div class="table-responsive">
						<table class="table table-striped table-actions-bar datatable">
							<thead>
								<tr>
									<th>#</th>
									<th>Backup File name</th>
									<th>Created On</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$i = 1;
								foreach ($backups as $b) {
								?>
								<tr>
									<td><?php echo $i++; ?></td>
									<td><?php echo $b->backup_file_name; ?></td>
									<td><?php echo date('d-m-Y', strtotime($b->last_updated)); ?></td>
									<td>
										<a href="<?php echo base_url(); ?>backup/<?php echo $b->backup_file_name; ?>" class="btn btn-success btn-xs">Download <i class="fa fa-download"></i></a>
									</td>
								</tr>
								<?php
								}
								?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>