<div class="content-page">
	<div class="content">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<h4 class="page-title m-t-0 m-b-20">Dashboard</h4>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-3 col-sm-6">
					<a href="<?php echo base_url() . 'admin/gigs'; ?>">
						<div class="dash-widget">
							<i class="mdi mdi-account-box text-custom"></i>
							<h2 class="m-0 text-dark counter font-600"><?php echo $total_gigs; ?></h2>
							<div class="text-muted m-t-5">Total Favores</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-sm-6">
					<a href="<?php echo base_url() . 'admin/user'; ?>">
						<div class="dash-widget">
							<i class="mdi mdi-account-box text-custom"></i>
							<h2 class="m-0 text-dark counter font-600"><?php echo $total_user; ?></h2>
							<div class="text-muted m-t-5">Total Usuarios</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-sm-6">
					<a href="<?php echo base_url() . 'admin/orders'; ?>">
						<div class="dash-widget">
							<i class="mdi mdi-store text-custom"></i>
							<h2 class="m-0 text-dark counter font-600"><?php echo $total_orders; ?></h2>
							<div class="text-muted m-t-5">Total Ordenes</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-sm-6">
					<a href="<?php echo base_url() . 'admin/completed_orders'; ?>">
						<div class="dash-widget">
							<i class="mdi mdi-cart text-custom"></i>
							<h2 class="m-0 text-dark counter font-600"><?php echo $completed_orders; ?></h2>
							<div class="text-muted m-t-5">Ordenes Completadas</div>
						</div>
					</a>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-6">
					<div class="card-box">
						<a href="<?php echo base_url() . "admin/orders"; ?>" class="pull-right btn btn-default btn-sm">Ver Todos</a>
						<h4 class="text-dark header-title m-t-0 m-b-20">Ordenes Recientes</h4>
						<div class="table-responsive">
							<table class="table">
								<thead>
									<tr>
										<th>Favor</th>
										<th>Fecha Orden</th>
										<th>Id Transaccion</th>
										<th>Monto</th>
									</tr>
								</thead>
								<tbody>
									<?php
									if (!empty($recent_orders)) {
									foreach ($recent_orders as $recent) {
										$case = $recent['currency_type'];
										switch ($case) {
											case 'FT':
												$rate_symbol = "FT";
											case 'USD':
												$rate_symbol = "$";
												break;
											case 'EUR':
												$rate_symbol = "€";
												break;
											case 'GBP':
												$rate_symbol = "£";
												break;
											case 'INR':
												$rate_symbol = '₹';
												break;
											default:
												$rate_symbol = "$";
												break;
										}
										$rate = $recent['item_amount'];
										$price = $rate_symbol . $rate;
										$image = base_url() . 'assets/img/gig-small-50_35.jpg';
										if (!empty($recent['gig_image_thumb']) && file_exists($recent['gig_image_thumb'])) {
											$image = base_url() . $recent['gig_image_thumb'];
										}
									?>
									<tr>
										<td><img src="<?php echo $image; ?>" class="gig-img" alt=""> </td>
										<td><?php echo date('d M Y', strtotime(str_replace('-', '/', $recent['created_at'])));  ?></td>
										<td><?php echo ($recent['paypal_uid'])?$recent['paypal_uid']:'-'; ?></td>
										<td><?php echo $price; ?></td>
									</tr>
										<?php }
									} else { ?>
									<tr>
										<td colspan="4">
											<p class="text-danger text-center m-b-0">No hat datos</p>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="card-box">
						<a href="<?php echo base_url() . "admin/gigs"; ?>" class="pull-right btn btn-default btn-sm">Ver Todos</a>
						<h4 class="text-dark header-title m-t-0 m-b-20">Favores Populares</h4>
						<div class="table-responsive">
							<table class="table">
								<thead>
									<tr>
										<th>favor</th>
										<th>Fecha agregado</th>
										<th>Vistas</th>
										<th>Monto</th>
									</tr>
								</thead>
								<tbody>
									<?php
									if (!empty($popular_orders)) {
									foreach ($popular_orders as $popular_order) {
										$case = $popular_order['currency_type'];
										switch ($case) {
											case 'FT':
												$rate_symbol = "FT";
											case 'USD':
												$rate_symbol = "$";
												break;
											case 'EUR':
												$rate_symbol = "€";
												break;
											case 'GBP':
												$rate_symbol = "£";
												break;
											default:
												$rate_symbol = "$";
												break;
										}
										$rate = $popular_order['gig_price'];
										$price = $rate_symbol . $rate;
										$image = base_url() . 'assets/img/gig-small-50_35.jpg';
										if (!empty($popular_order['gig_image']) && file_exists($popular_order['gig_image'])) {
											$image = base_url() . $popular_order['gig_image'];
										}
									?>
									<tr>
										<td><img src="<?php echo $image; ?>" class="gig-img" alt="<?php echo str_replace('-', ' ', $popular_order['title']); ?>"> </td>
										<td><?php echo date('d M Y', strtotime(str_replace('-', '/', $popular_order['created_date'])));  ?></td>
										<td><b><?php echo $popular_order['total_views']; ?></b></td>
										<td><?php echo $price; ?></td>
									</tr>
										<?php }
									} else { ?>
									<td colspan="4">
										<p class="text-danger text-center m-b-0">No hay datos</p>
									</td>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>