<div class="content-page">
	<div class="content">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<h4 class="page-title m-b-20 m-t-0">Retiros Pagados</h4>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="card-box">
						<div class="table-responsive">
							<table class="table table-actions-bar table-striped releasetable m-b-0">
								<thead>
									<tr>
										<th>#</th>
										<th>Orden Id</th>
										<th>Orden Fecha</th>
										<th>Id Transaccion</th>
										<th>Vendedor</th>
										<th>Comprador</th>
										<th>Monto</th>
										<th>Comision</th>
										<th>Monto a Vendedor</th>
										<th>Estatus</th>
									</tr>
								</thead>
								<tbody>
									<?php
									if (!empty($list)) {
										$sno = 1;
									foreach ($list as $item) {
										$case = $item['currency_type'];
										switch ($case) {
											case 'FT':
												$rate_symbol = "FT";
											case 'USD':
												$rate_symbol = "$";
												break;
											case 'EUR':
												$rate_symbol = "€";
												break;
											case 'GBP':
												$rate_symbol = "£";
												break;
											default:
												$rate_symbol = "$";
												break;
										}
										$rate_symbol = currency_conversion($case);
										$rate = $item['item_amount'];
										$source = $item['source'];
										$price = $rate_symbol . $rate;
										$commision_rate = (($rate * $item['commision']) / 100);
										$seller_amount = $rate - $commision_rate;
										$status = 'Activo';
										if ($item['status'] == 1) {
											$status = 'Inactivo';
										}
										$parent_category = 'None';
										$status = $item['seller_status'];
										if ($status == 1) {
											$sts = 'Nuevo';
											$class = 'label-success';
										} elseif ($status == 2) {
											$sts = 'Pendiente';
											$class = 'label-warning';
										} elseif ($status == 3) {
											$sts = 'Procesando';
											$class = 'label-primary';
										} elseif ($status == 4) {
											$sts = 'Reintegrado';
											$class = 'label-danger';
										} elseif ($status == 5) {
											$sts = 'Cancelado';
											$class = 'label-danger';
										} elseif ($status == 6) {
											$sts = 'Completado';
											$class = 'label-success';
										}
										$created_on = '-';
										if (isset($item['created_at'])) {
											if (!empty($item['created_at']) && $item['created_at'] != "0000-00-00 00:00:00") {
												$created_on = '<span>' . date('d M Y', strtotime($item['created_at'])) . '</span>';
											}
										}
										?>
										<tr id="row_id_<?php echo $item['id']; ?>">
											<td><?php echo $sno++; ?></td>
											<td><?php echo $item['id']; ?></td>
											<td><?php echo $created_on; ?></td>
											<td>
											<?php
												if ($source == 'paytabs') {
													echo $item['paytabs_uid'];
												} else {
													echo $item['paypal_uid'];
												}
											?>
											</td>
											<td><?php echo $item['seller_name']; ?></td>
											<td><?php echo $item['buyer_name']; ?></td>
											<td><?php echo $price; ?></td>
											<td><?php echo $rate_symbol . $commision_rate; ?></td>
											<td><?php echo $rate_symbol . $seller_amount; ?></td>
											<td>
												<div class="withdraw-btn">
													<?php if ($item['payment_status'] == 2) { ?>
													<span class="label label-success">Pagado</span>
													<?php } ?>
												</div>
											</td>
										</tr>
									<?php
									}
								} else { ?>
									<tr>
										<td colspan="9">
											<p class="text-center text-danger m-b-0">No hay data</p>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>