<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Language_web_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    public function page_list()
    {
        return $this->db->get('pages')->result_array();
    }
    var $column_order = array(null, 'L.lang_key', 'L.lang_value', 'L.language');
    var $column_search = array('L.lang_key', 'L.lang_value', 'L.language');
    var $order = array('L.sno' => 'DESC');
    var $request_details = 'language_management L';
    private function p_get_datatables_query()
    {
        $this->db->select('*');
        $this->db->from($this->request_details);
        $i = 0;
        foreach ($this->column_search as $item) {
            if ($this->input->post('search')['value']) {
                if ($i === 0) {
                    $this->db->group_start();
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    if ($item == 'status') {
                        if (strtolower($this->input->post('search')['value']) == 'active') {
                            $search_val = 1;
                            $this->db->or_like($item, $search_val);
                        }
                        if (strtolower($this->input->post('search')['value']) == 'inactive') {
                            $search_val = 0;
                            $this->db->or_like($item, $search_val);
                        }
                    } else {
                        $search_val = $this->input->post('search')['value'];
                        $this->db->or_like($item, $search_val);
                    }
                }
                if (count($this->column_search) - 1 == $i)
                    $this->db->group_end();
            }
            $i++;
        }
        if ($this->input->post('order')) {
            $this->db->order_by($this->column_order[$this->input->post('order')['0']['column']], $this->input->post('order')['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
    public function language_list()
    {
        $this->p_get_datatables_query();
        if ($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
        $this->db->group_by(array(
            'L.lang_key'
        ));
        $query = $this->db->get();
        return $query->result_array();
    }
    public function language_list_all()
    {
        $this->db->from($this->request_details);
        return $this->db->count_all_results();
    }
    public function language_list_filtered()
    {
        $this->p_get_datatables_query();
        $this->db->group_by(array(
            'L.lang_key'
        ));
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function currenct_page_key_value($inputs)
    {
        $my_keys = array();
        if (!empty($inputs)) {
            foreach ($inputs as $input) {
                $my_keys[] = $input['lang_key'];
            }
        }
        $my_final_values = array();
        if (!empty($my_keys)) {
            $this->db->select('sno,lang_key,lang_value,language');
            $this->db->from('language_management');
            $this->db->where_in('lang_key', $my_keys);
            $this->db->order_by('lang_key');
            $my_final = $this->db->get()->result_array();
            if (!empty($my_final)) {
                foreach ($my_final as $keyvalue) {
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['name']     = $keyvalue['lang_value'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['lang_key'] = $keyvalue['lang_key'];
                }
            }
        }
        return $my_final_values;
    }
    public function active_language()
    {
        $query  = $this->db->query("SELECT language, language_value,tag FROM `language` WHERE status = 1");
        $result = $query->result_array();
        return $result;
    }
    public function keyword_model()
    {
        if (!empty($this->input->post('field_name'))) {
            $data             = array();
            $datas            = array();
            $field_name       = trim($this->input->post('field_name'));
            $data['lang_key'] = 'lg_' . str_replace(array(
                ' ',
                '!',
                '&'
            ), '_', strtolower($field_name));
            $data['language'] = 'en';
            $this->db->where($data);
            $record = $this->db->count_all_results('language_management');
            if ($record >= 1) {
                return false;
            } else {
                $datas['lang_key']   = 'lg_' . str_replace(array(
                    ' ',
                    '!',
                    '&'
                ), '_', strtolower($field_name));
                $datas['lang_value'] = trim($this->input->post('name'));
                $datas['language']   = 'en';
                $result              = $this->db->insert('language_management', $datas);
                return $result;
            }
        }
    }
    public function page_model()
    {
        if (!empty($this->input->post('page_name'))) {
            $data               = array();
            $page_name          = trim($this->input->post('page_name'));
            $page_key           = str_replace(array(
                ' ',
                '!',
                '&'
            ), '_', strtolower($page_name));
            $data['page_title'] = $page_name;
            $data['page_key']   = $page_key;
            $data['status']     = 1;
            $this->db->where($data);
            $record = $this->db->count_all_results('pages');
            if ($record >= 1) {
                return false;
            } else {
                $result = $this->db->insert('pages', $data);
                return $result;
            }
        }
    }
    public function language_model()
    {
        $where                   = array();
        $where['tag']            = $this->input->post('tag');
        $where['language']       = $this->input->post('language');
        $where['language_value'] = $this->input->post('value');
        $this->db->where($where);
        $record = $this->db->count_all_results('language');
        if ($record == 1) {
            return false;
        } else {
            $data   = array(
                'language_value' => trim($this->input->post('value')),
                'language' => trim($this->input->post('language')),
                'tag' => trim($this->input->post('tag')),
                'status' => 2
            );
            $result = $this->db->insert('language', $data);
            return $result;
        }
    }
    public function lang_data()
    {
        $query = $this->db->query(" SELECT * FROM language");
        return $query->result_array();
    }
}
