<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Language_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    public function page_list()
    {
        return $this->db->get('pages')->result_array();
    }
    var $column_order = array(null, 'L.lang_key', 'L.lang_value', 'L.language');
    var $column_search = array('L.lang_key', 'L.lang_value', 'L.language');
    var $order = array('L.sno' => 'DESC');
    var $request_details = 'app_language_management L';
    var $users = 'pages P';
    private function p_get_datatables_query()
    {
        $this->db->select('L.*, P.page_title');
        $this->db->from($this->request_details);
        $this->db->join($this->users, 'P.page_key = L.page_key', 'left');
        $i = 0;
        foreach ($this->column_search as $item) {
            if ($this->input->post('search')['value']) {
                if ($i === 0) {
                    $this->db->group_start();
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    if ($item == 'status') {
                        if (strtolower($this->input->post('search')['value']) == 'active') {
                            $search_val = 1;
                            $this->db->or_like($item, $search_val);
                        }
                        if (strtolower($this->input->post('search')['value']) == 'inactive') {
                            $search_val = 0;
                            $this->db->or_like($item, $search_val);
                        }
                    } else {
                        $search_val = $this->input->post('search')['value'];
                        $this->db->or_like($item, $search_val);
                    }
                }
                if (count($this->column_search) - 1 == $i)
                    $this->db->group_end();
            }
            $i++;
        }
        if ($this->input->post('order')) {
            $this->db->order_by($this->column_order[$this->input->post('order')['0']['column']], $this->input->post('order')['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
    public function language_list($page_key)
    {
        $this->p_get_datatables_query();
        if ($this->input->post('length') != -1)
            $this->db->where('L.page_key', $page_key);
        $this->db->limit($this->input->post('length'), $this->input->post('start'));
        $this->db->group_by(array(
            'L.page_key',
            'L.lang_key'
        ));
        $query = $this->db->get();
        return $query->result_array();
    }
    public function language_list_all($page_key)
    {
        $this->db->where('L.page_key', $page_key);
        $this->db->from($this->request_details);
        return $this->db->count_all_results();
    }
    public function language_list_filtered($page_key)
    {
        $this->p_get_datatables_query();
        $this->db->where('L.page_key', $page_key);
        $this->db->group_by(array(
            'L.page_key',
            'L.lang_key'
        ));
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function currenct_page_key_value($inputs)
    {
        $my_keys = array();
        if (!empty($inputs)) {
            foreach ($inputs as $input) {
                $my_keys[]     = $input['lang_key'];
                $mypage_keys[] = $input['page_key'];
            }
        }
        $my_final_values = array();
        if (!empty($my_keys)) {
            $this->db->select('sno,lang_key,lang_value,language,placeholder,validation1,validation2,validation3,type,page_key');
            $this->db->from('app_language_management');
            $this->db->where_in('lang_key', $my_keys);
            $this->db->where_in('page_key', $mypage_keys);
            $this->db->order_by('lang_key');
            $my_final = $this->db->get()->result_array();
            if (!empty($my_final)) {
                foreach ($my_final as $keyvalue) {
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['name']        = $keyvalue['lang_value'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['placeholder'] = $keyvalue['placeholder'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['validation1'] = $keyvalue['validation1'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['validation2'] = $keyvalue['validation2'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['validation3'] = $keyvalue['validation3'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['type']        = $keyvalue['type'];
                    $my_final_values[$keyvalue['lang_key']][$keyvalue['language']]['lang_key']    = $keyvalue['lang_key'];
                }
            }
        }
        return $my_final_values;
    }
    public function get_language_id($page_key)
    {
        $this->db->select('p_id');
        $this->db->where('page_key', $page_key);
        $query = $this->db->get('pages');
        return $query->row_array();
    }
    public function get_keyword_id($page_key)
    {
        $this->db->select('sno');
        $this->db->where('page_key', $page_key);
        $query = $this->db->get('pages');
        return $query->row_array();
    }
    public function active_language()
    {
        $query  = $this->db->query("SELECT language, language_value,tag FROM `language` WHERE status = 1");
        $result = $query->result_array();
        return $result;
    }
    public function keyword_model()
    {
        if (!empty($this->input->post('field_name'))) {
            $data             = array();
            $datas            = array();
            $field_name       = trim($this->input->post('field_name'));
            $data['lang_key'] = $field_name;
            $data['page_key'] = $this->input->post('page_key');
            $data['language'] = 'en';
            $this->db->where($data);
            $record = $this->db->count_all_results('app_language_management');
            if ($record >= 1) {
                return false;
            } else {
                $datas['lang_key']    = $field_name;
                $datas['lang_value']  = trim($this->input->post('name'));
                $datas['page_key']    = $this->input->post('page_key');
                $datas['type']        = $this->input->post('type');
                $datas['placeholder'] = !empty($this->input->post('placeholder')) ? $this->input->post('placeholder') : '';
                $datas['validation1'] = !empty($this->input->post('validation1')) ? $this->input->post('validation1') : '';
                $datas['validation2'] = !empty($this->input->post('validation2')) ? $this->input->post('validation2') : '';
                $datas['validation3'] = !empty($this->input->post('validation3')) ? $this->input->post('validation3') : '';
                $datas['language']    = 'en';
                $result               = $this->db->insert('app_language_management', $datas);
                return $result;
            }
        }
    }
    public function page_model()
    {
        if (!empty($this->input->post('page_name'))) {
            $data               = array();
            $page_name          = trim($this->input->post('page_name'));
            $page_key           = str_replace(array(
                ' ',
                '!',
                '&'
            ), '_', strtolower($page_name));
            $data['page_title'] = $page_name;
            $data['page_key']   = $page_key;
            $data['status']     = 1;
            $this->db->where($data);
            $record = $this->db->count_all_results('pages');
            if ($record >= 1) {
                return false;
            } else {
                $result = $this->db->insert('pages', $data);
                return $result;
            }
        }
    }
    public function language_model()
    {
        $where                   = array();
        $where['tag']            = $this->input->post('tag');
        $where['language']       = $this->input->post('language');
        $where['language_value'] = $this->input->post('value');
        $where['deleted_status'] = 0;
        $this->db->where($where);
        $record = $this->db->count_all_results('language');
        if ($record == 1) {
            return false;
        } else {
            $data               = array(
                'language_value' => trim($this->input->post('value')),
                'language' => trim($this->input->post('language')),
                'tag' => trim($this->input->post('tag')),
                'status' => 1
            );
            $uploaded_file_name = '';
            if (isset($_FILES) && isset($_FILES['flag']['name']) && !empty($_FILES['flag']['name'])) {
                $uploaded_file_name     = $_FILES['flag']['name'];
                $uploaded_file_name_arr = explode('.', $uploaded_file_name);
                $filename               = isset($uploaded_file_name_arr[0]) ? $uploaded_file_name_arr[0] : '';
                $this->load->library('common');
                $upload_sts = $this->common->global_file_upload('uploads/flag/', 'flag', time() . $filename);
                if (isset($upload_sts['success']) && $upload_sts['success'] == 'y') {
                    $uploaded_file_name = $upload_sts['data']['file_name'];
                    if (!empty($uploaded_file_name)) {
                        $image_url        = 'uploads/flag/' . $uploaded_file_name;
                        $data['flag_img'] = $this->image_resize(23, 20, $image_url, 'thu_' . $filename);
                    }
                }
            }
            $result = $this->db->insert('language', $data);
            return $result;
        }
    }
    public function image_resize($width = 0, $height = 0, $image_url, $filename)
    {
        $source_path = base_url() . $image_url;
        list($source_width, $source_height, $source_type) = getimagesize($source_path);
        switch ($source_type) {
            case IMAGETYPE_GIF:
                $source_gdim = imagecreatefromgif($source_path);
                break;
            case IMAGETYPE_JPEG:
                $source_gdim = imagecreatefromjpeg($source_path);
                break;
            case IMAGETYPE_PNG:
                $source_gdim = imagecreatefrompng($source_path);
                break;
        }
        $source_aspect_ratio  = $source_width / $source_height;
        $desired_aspect_ratio = $width / $height;
        if ($source_aspect_ratio > $desired_aspect_ratio) {
            $temp_height = $height;
            $temp_width  = (int) ($height * $source_aspect_ratio);
        } else {
            $temp_width  = $width;
            $temp_height = (int) ($width / $source_aspect_ratio);
        }
        $temp_gdim = imagecreatetruecolor($temp_width, $temp_height);
        imagecopyresampled($temp_gdim, $source_gdim, 0, 0, 0, 0, $temp_width, $temp_height, $source_width, $source_height);
        $x0           = ($temp_width - $width) / 2;
        $y0           = ($temp_height - $height) / 2;
        $desired_gdim = imagecreatetruecolor($width, $height);
        imagecopy($desired_gdim, $temp_gdim, 0, 0, $x0, $y0, $width, $height);
        $filename_without_extension = preg_replace('/\\.[^.\\s]{3,4}$/', '', $filename);
        $image_url                  = "uploads/flag/" . $filename_without_extension . "_" . $width . "_" . $height . ".jpg";
        imagejpeg($desired_gdim, $image_url);
        return $image_url;
    }
    public function lang_data()
    {
        $query = $this->db->query(" SELECT * FROM language where deleted_status=0");
        return $query->result_array();
    }
}
