<?php
ob_start();
class Wallet extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        /*if ($this->session->userdata('SESSION_USER_ID') == '') {
            redirect(base_url(''));
        }*/
		if ($this->session->userdata('SESSION_USER_ID') == '') {
            if(!empty($this->input->post('item_number1'))) {
               $this->session->set_userdata('SESSION_USER_ID',$this->input->post('item_number1'));
            } else if(!empty($this->input->post('item_number'))) {
               $this->session->set_userdata('SESSION_USER_ID',$this->input->post('item_number'));
            } else{
				redirect(base_url(''));
            }
        }
        $this->load->helper('custom_language');
        $this->load->helper('common_helper');
        $this->load->library('paypal_lib');
        $default_language_select = default_language();
        if ($this->session->userdata('user_select_language') == '') {
            $this->data['user_selected'] = $default_language_select['language_value'];
        } else {
            $this->data['user_selected'] = $this->session->userdata('user_select_language');
        }
        $this->data['active_language']  = $active_lang = active_language();
        $lg                             = custom_language($this->data['user_selected']);
        $this->data['default_language'] = $lg['default_lang'];
        $this->data['user_language']    = $lg['user_lang'];
        $this->user_selected            = (!empty($this->data['user_selected'])) ? $this->data['user_selected'] : 'en';
        $this->default_language         = (!empty($this->data['default_language'])) ? $this->data['default_language'] : '';
        $this->user_language            = (!empty($this->data['user_language'])) ? $this->data['user_language'] : '';
        $this->load->helper('favourites');
        $common_settings  = gigs_settings();
        $default_currency = 'USD';
        if (!empty($common_settings)) {
            foreach ($common_settings as $datas) {
                if ($datas['key'] == 'currency_option') {
                    $default_currency = $datas['value'];
                }
            }
        }
        $this->load->helper('currency');
        $this->default_currency      = $default_currency;
        $this->default_currency_sign = currency_sign($default_currency);
        $this->smtp_config           = smtp_mail_config();
        $this->data['theme']         = 'user';
        $this->data['module']        = 'wallet';
        $this->load->model('user_panel_model');
        $this->load->model('Stripe_model');
        $this->data['client_list']              = $this->user_panel_model->get_client_list();
        $this->data['categories_subcategories'] = $this->user_panel_model->categories();
        $this->data['footer_main_menu']         = $this->user_panel_model->footer_main_menu();
        $this->data['footer_sub_menu']          = $this->user_panel_model->footer_sub_menu();
        $this->data['system_setting']           = $this->user_panel_model->system_setting();
        $this->data['policy_setting']           = $this->user_panel_model->policy_setting();
        $query                                  = $this->db->query("select * from system_settings WHERE status = 1");
        $result                                 = $query->result_array();
        $this->base_domain                      = base_url();
        $this->publishable_key                  = '';
        $this->paypal_option                    = '';
        $this->paypal_id                        = '';
        $this->paytabs_email                    = '';
        $this->paytabs_secretkey                = '';
        $paytabs_option                         = '';
        if (!empty($result)) {
            foreach ($result as $data) {
                if ($data['key'] == 'email_address') {
                    $this->email_address = !empty($data['value']) ? $data['value'] : 'mail@example.com';
                }
                if ($data['key'] == 'paypal_secret_key') {
                    $this->paypal_secret_key = !empty($data['value']) ? $data['value'] : '';
                }
                if ($data['key'] == 'paypal_secret_value') {
                    $this->paypal_secret_value = !empty($data['value']) ? $data['value'] : '';
                }
                if ($data['key'] == 'email_tittle') {
                    $this->email_tittle = !empty($data['value']) ? $data['value'] : 'Gigs';
                }
                if ($data['key'] == 'publishable_key') {
                    $this->publishable_key = $data['value'];
                }
                if ($data['key'] == 'live_secret_key') {
                    $this->live_secret_key = $data['value'];
                }
				if ($data['key'] == 'live_publishable_key') {
                    $this->live_publishable_key = $data['value'];
                }
				if ($data['key'] == 'razorpaylive_apikey') {
                    $this->razorpaylive_apikey = $data['value'];
                }
                if ($data['key'] == 'razorpaylive_apisecret') {
                    $this->razorpaylive_apisecret = $data['value'];
                }                
				if ($data['key'] == 'razorpay_apikey') {
                    $this->razorpay_apikey = $data['value'];
                }
                if ($data['key'] == 'razorpay_apisecret') {
                    $this->razorpay_apisecret = $data['value'];
                }
                if ($data['key'] == 'stripe_option') {
                    $this->stripe_option = $data['value'];
                }
                if ($data['key'] == 'paypal_allow') {
                    $this->paypal_allow = $data['value'];
                }
                if ($data['key'] == 'paytabs_allow') {
                    $this->paytabs_allow = $data['value'];
                }
                if ($data['key'] == 'stripe_allow') {
                    $this->stripe_allow = $data['value'];
                }
				if ($data['key'] == 'razorpay_allow') {
                    $this->razorpay_allow = $data['value'];
                }
				if ($data['key'] == 'razorpay_option') {
                    $this->razorpay_option = $data['value'];
                }
                if ($data['key'] == 'paypal_option') {
                    $this->paypal_option = $data['value'];
                }
                if ($data['key'] == 'paytabs_option') {
                    $paytabs_option = $data['value'];
                }
                if ($data['key'] == 'logo_front') {
                    $this->logo_front = base_url() . $data['value'];
                }
                if ($data['key'] == 'site_name' || $data['key'] == 'website_name') {
                    $this->site_name = $data['value'];
                }
                $this->data['currency_option'] = 'USD';
                if ($data['key'] == 'currency_option') {
                    $this->data['currency_option'] = $data['value'];
                }
            }
        }
        $this->data['publishable_key'] = $this->publishable_key;
        $this->data['paypal_allow']    = $this->paypal_allow;
        $this->data['paytabs_allow']   = $this->paytabs_allow;
        $this->data['stripe_allow']    = $this->stripe_allow;
		$this->data['razorpay_allow']  = $this->razorpay_allow;
		$this->data['razorpay_option']  = $this->razorpay_option;
		$this->data['razorpaylive_apikey']  = $this->razorpaylive_apikey;
		$this->data['razorpaylive_apisecret']  = $this->razorpaylive_apisecret;
		$this->data['razorpay_apikey']  = $this->razorpay_apikey;
		$this->data['razorpay_apisecret']  = $this->razorpay_apisecret;
        $this->data['logo']            = $this->user_panel_model->get_logo();
        $this->data['slogan']          = $this->user_panel_model->get_slogan();
        if ($this->paypal_option == 1) {
            $this->paypal_id = $this->db->select('sandbox_email')->get('paypal_details')->row()->sandbox_email;
        }
        if ($this->paypal_option == 2) {
            $this->paypal_id = $this->db->select('email')->get('paypal_details')->row()->email;
        }
        if ($paytabs_option == 1) {
            $this->paytabs_email     = $this->db->select('sandbox_email')->get('paytabs_details')->row()->sandbox_email;
            $this->paytabs_secretkey = $this->db->select('sandbox_secretkey')->get('paytabs_details')->row()->sandbox_secretkey;
        }
        if ($paytabs_option == 2) {
            $this->paytabs_email     = $this->db->select('email')->get('paytabs_details')->row()->email;
            $this->paytabs_secretkey = $this->db->select('secretkey')->get('paytabs_details')->row()->secretkey;
        }
    }
    public function index()
    {
        $this->data['page']   = 'index';
        $user_id              = $this->session->userdata('SESSION_USER_ID');
        $user_details = $this->user_panel_model->get_user_data($user_id);
        $wallet_name             = $user_details['favorcoin_address_username'];
        $this->data['wallet'] = $this->Stripe_model->get_wallet($user_id);
        $wallet_history       = $this->Stripe_model->get_wallet_history_info($user_id);
        $credit               = $debit = 0;
        $user_currency        = get_user_currency();
        if (count($wallet_history) > 0) {
            foreach ($wallet_history as $key => $value) {
                if ($value['credit_wallet'] != 0) {
                    $credit_amt = get_gigs_currency($value['credit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $credit += round($credit_amt, 2);
                }
                if ($value['debit_wallet'] != 0) {
                    $debit_amt = get_gigs_currency($value['debit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $debit += round($debit_amt, 2);
                }
            }
            $this->data['total_credit'] = $credit;
            $this->data['total_debit']  = $debit;
        } else {
            $this->data['total_credit'] = 0;
            $this->data['total_debit']  = 0;
        }
        include APPPATH . 'classes/Favorcoin.php';
        $favorcoin = new Favorcoin('coinuser','coinpassword','208.85.18.35','6332');

        $wallet_balance = $favorcoin->getbalance($wallet_name);
        $this->data['favorcoin_balance'] = $wallet_balance;
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function payment()
    {
        removeTag($this->input->post());
        $params = $this->input->post();
        if (!empty($params)) {
            $amount        = $params['wallet_amt'];
            $user_id       = $this->session->userdata('SESSION_USER_ID');
            $user          = $this->db->where('USERID', $user_id)->get('members')->row_array();
            $user_name     = $user['username'];
            $user_token    = $user['unique_code'];
            $currency_type = $user['currency_code'];
            if ($this->input->post('group2') == 'PayTabs') {
                $this->paytabs_payments($amount, $user_id, $user_name, $currency_type, $user_token);
            } else {
                $this->buy($amount, $user_id, $user_name, $currency_type, $user_token);
            }
        }
    }
    function buy($amount, $user_id, $g_name, $currency_type, $user_token)
    {
        //Set variables for paypal form
        $returnURL = base_url($this->data['theme'] . '/wallet/paypal_success'); //payment success url
        $cancelURL = base_url($this->data['theme'] . '/wallet/paypal_cancel'); //payment cancel url
        $notifyURL = base_url() . 'user/buy_service/ipn'; //ipn url
        $userID    = $user_id; //current user id
        $name      = $g_name;
        $this->paypal_lib->add_field('return', $returnURL);
        $this->paypal_lib->add_field('cancel_return', $cancelURL);
        $this->paypal_lib->add_field('notify_url', $notifyURL);
        $this->paypal_lib->add_field('item_name', $name);
        $this->paypal_lib->add_field('custom', $userID);
        $this->paypal_lib->add_field('item_number', $userID);
        $this->paypal_lib->add_field('amount', $amount);
        $this->paypal_lib->add_field('currency_code', $currency_type);
        $this->paypal_lib->add_field('business', $this->paypal_id);
        $this->paypal_lib->paypal_auto_form();
    }
    public function paypal_success()
    {
        removeTag($this->input->post());
        if (!empty($this->input->post('txn_id'))) {
            $paypalInfo  = $this->input->post();
            $txn_id      = $paypalInfo['txn_id'];
            $item_number = $paypalInfo['item_number1'];
        } else {
            $paypalInfo  = $this->input->get();
            $txn_id      = $paypalInfo['tx'];
            $item_number = $paypalInfo['item_number'];
        }
		if($item_number == '') {
			if(isset($paypalInfo['item_number']) && !empty($paypalInfo['item_number'])) {
				$item_number = $paypalInfo['item_number'];
			}
		}
		if($paypalInfo['amt'] == '') {
			$paypalInfo['amt'] = $paypalInfo['mc_gross'];
		}
        if (!empty($txn_id) && !empty($item_number)) {
            $message                  = '';
            $order_id                 = $txn_id;
            $table_data['paypal_uid'] = $txn_id;
            $result                   = $this->Stripe_model->user_wallet_history_flow($item_number, $txn_id, $paypalInfo['amt']);
            if ($result == true) {
                $message = (!empty($this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'])) ? $this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'] : $this->default_language['en']['lg_wallet_amount_add_wallet'];
                $this->session->set_flashdata('msg_success', $message);
                redirect('wallet');
            } else {
                $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
                $this->session->set_flashdata('message', $message);
                redirect('wallet');
            }
        }
    }
    public function paypal_cancel()
    {
        $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
        $this->session->set_flashdata('message', $message);
        redirect('wallet');
    }
    public function paytabs_payments($amount, $user_id, $g_name, $currency_type, $user_token)
    {
        $ip          = isset($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];
        $USERID      = $this->session->userdata('SESSION_USER_ID');
        $userdetails = $this->db->query('select m.email,m.fullname,m.city,m.contact,m.address,m.zipcode,c.sortname,c.country,s.state_name from members as m 
     LEFT JOIN country as c on c.id=m.country
     LEFT JOIN states as s on s.state_id=m.state
     WHERE USERID=' . $USERID . '')->row_array();
        $details     = array(
            "merchant_email" => $this->paytabs_email,
            "secret_key" => $this->paytabs_secretkey,
            "site_url" => base_url($this->data['theme']),
            "return_url" => base_url($this->data['theme'] . '/wallet/paytabs_success/'),
            "title" => $g_name,
            "cc_first_name" => $userdetails['fullname'],
            "cc_last_name" => "Not Mentioned",
            "cc_phone_number" => !empty($userdetails['contact']) ? $userdetails['contact'] : '0000',
            "phone_number" => !empty($userdetails['contact']) ? $userdetails['contact'] : '0000',
            "email" => $userdetails['email'],
            "products_per_title" => $g_name,
            "unit_price" => $amount,
            "quantity" => "1",
            "other_charges" => "0",
            "amount" => $amount,
            "discount" => "0",
            "currency" => $currency_type,
            "reference_no" => $USERID,
            "ip_customer" => $ip,
            "ip_merchant" => $ip,
            "billing_address" => !empty($userdetails['address']) ? $userdetails['address'] : 'Not Mentioned',
            "city" => !empty($userdetails['city']) ? $userdetails['city'] : 'Not Mentioned',
            "state" => !empty($userdetails['state_name']) ? $userdetails['state_name'] : 'Not Mentioned',
            "postal_code" => !empty($userdetails['zipcode']) ? $userdetails['zipcode'] : 'Not Mentioned',
            "country" => !empty($userdetails['sortname']) ? $userdetails['sortname'] : 'IND',
            "shipping_first_name" => $userdetails['fullname'],
            "shipping_last_name" => "Not Mentioned",
            "address_shipping" => !empty($userdetails['address']) ? $userdetails['address'] : 'Not Mentioned',
            "state_shipping" => !empty($userdetails['state_name']) ? $userdetails['state_name'] : 'Not Mentioned',
            "city_shipping" => !empty($userdetails['city']) ? $userdetails['city'] : 'Not Mentioned',
            "postal_code_shipping" => !empty($userdetails['zipcode']) ? $userdetails['zipcode'] : 'Not Mentioned',
            "country_shipping" => !empty($userdetails['sortname']) ? $userdetails['sortname'] : 'IND',
            "msg_lang" => "English",
            "cms_with_version" => "CodeIgniter 3.1.9"
        );
        $ch          = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://www.paytabs.com/apiv2/create_pay_page");
        curl_setopt($ch, CURLOPT_POST, 1);
        // In real life you should use something like:
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($details));
        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $info     = curl_getinfo($ch);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
        }
        curl_close($ch);
        $pay_tabs_response = json_decode($response);
        if (!empty($pay_tabs_response->payment_url)) {
            redirect(urldecode($pay_tabs_response->payment_url));
        } else {
            $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
            $this->session->set_flashdata('msg_error', $message);
            redirect('wallet');
        }
    }
    public function paytabs_success()
    {
        removeTag($this->input->post());
        $paytabInfo = $this->input->post();
        if (!empty($paytabInfo)) {
            $details = array(
                "merchant_email" => $this->paytabs_email,
                "secret_key" => $this->paytabs_secretkey,
                "payment_reference" => $paytabInfo['payment_reference']
            );
            $ch      = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://www.paytabs.com/apiv2/verify_payment");
            curl_setopt($ch, CURLOPT_POST, 1);
            // In real life you should use something like:
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($details));
            // Receive server response ...
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            $info     = curl_getinfo($ch);
            curl_close($ch);
            $pay_tabs_response = json_decode($response);
            if ($pay_tabs_response->response_code == '100') {
                if (!empty($pay_tabs_response->reference_no)) {
                    $user    = $this->Stripe_model->get_user_info($pay_tabs_response->reference_no);
                    $user_id = $pay_tabs_response->reference_no;
                    $txn_id  = $pay_tabs_response->transaction_id;
                    $amt     = $pay_tabs_response->amount;
                    $result  = $this->Stripe_model->user_wallet_history_flow($pay_tabs_response->reference_no, $txn_id, $amt);
                    if ($result == true) {
                        $message = (!empty($this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'])) ? $this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'] : $this->default_language['en']['lg_wallet_amount_add_wallet'];
                        $this->session->set_flashdata('msg_success', $message);
                        redirect('user/wallet');
                    } else {
                        $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
                        $this->session->set_flashdata('msg_error', $message);
                        redirect('wallet');
                    }
                }
            } else {
                $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
                $this->session->set_flashdata('msg_error', $message);
                redirect('wallet');
            }
        }
    }
    public function withdraw_wallet()
    {
        $this->data['page']               = 'withdraw';
        $user_id                          = $this->session->userdata('SESSION_USER_ID');
        $this->data['wallet']             = $this->Stripe_model->get_wallet($user_id);
        $wallet_history                   = $this->Stripe_model->get_wallet_history_info($user_id);
        $this->data['bank_account']       = $this->db->where('user_id', $user_id)->get('stripe_bank_details')->row_array();
        $credit                           = $debit = 0;
        $user_currency                    = get_user_currency();
        $this->data['user_currency_code'] = $user_currency['user_currency_code'];
        if (count($wallet_history) > 0) {
            foreach ($wallet_history as $key => $value) {
                if ($value['credit_wallet'] != 0) {
                    $credit_amt = get_gigs_currency($value['credit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $credit += $credit_amt;
                }
                if ($value['debit_wallet'] != 0) {
                    $debit_amt = get_gigs_currency($value['debit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $debit += $debit_amt;
                }
            }
            $withdraw_wallet = $this->db->where('user_id', $user_id)->where('transaction_status', 0)->get('wallet_withdraw')->result_array();
            $amt             = 0;
            foreach ($withdraw_wallet as $key => $value) {
                $amt += get_gigs_currency($value['amount'], $value['currency_code'], $user_currency['user_currency_code']);
            }
            $this->data['request_amt']  = $amt;
            $this->data['total_credit'] = round($credit, 2);
            $this->data['total_debit']  = round($debit, 2);
        } else {
            $this->data['total_credit'] = 0;
            $this->data['total_debit']  = 0;
            $this->data['request_amt']  = 0;
        }
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function transfer_wallet()
    {
        $this->data['page']               = 'transfer';
        $user_id                          = $this->session->userdata('SESSION_USER_ID');
        $this->data['wallet']             = $this->Stripe_model->get_wallet($user_id);
        $wallet_history                   = $this->Stripe_model->get_wallet_history_info($user_id);
        $this->data['bank_account']       = $this->db->where('user_id', $user_id)->get('stripe_bank_details')->row_array();
        $credit                           = $debit = 0;
        $user_currency                    = get_user_currency();
        $this->data['user_currency_code'] = $user_currency['user_currency_code'];
        if (count($wallet_history) > 0) {
            foreach ($wallet_history as $key => $value) {
                if ($value['credit_wallet'] != 0) {
                    $credit_amt = get_gigs_currency($value['credit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $credit += $credit_amt;
                }
                if ($value['debit_wallet'] != 0) {
                    $debit_amt = get_gigs_currency($value['debit_wallet'], $value['currency_code'], $user_currency['user_currency_code']);
                    $debit += $debit_amt;
                }
            }
            $withdraw_wallet = $this->db->where('user_id', $user_id)->where('transaction_status', 0)->get('wallet_withdraw')->result_array();
            $amt             = 0;
            foreach ($withdraw_wallet as $key => $value) {
                $amt += get_gigs_currency($value['amount'], $value['currency_code'], $user_currency['user_currency_code']);
            }
            $this->data['request_amt']  = $amt;
            $this->data['total_credit'] = round($credit, 2);
            $this->data['total_debit']  = round($debit, 2);
        } else {
            $this->data['total_credit'] = 0;
            $this->data['total_debit']  = 0;
            $this->data['request_amt']  = 0;
        }
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function paypal_access_token()
    {
        $secretkey                   = $this->paypal_secret_key;
        $secretvalue                 = $this->paypal_secret_value;
        $fields_string['grant_type'] = "client_credentials";
        if ($this->paypal_option == 2) {
            $url = "https://api.paypal.com/v1/oauth2/token";
        } else {
            $url = "https://api.sandbox.paypal.com/v1/oauth2/token";
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $secretkey . ":" . $secretvalue);
        $headers   = array();
        $headers[] = "Content-Type: application/json";
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $result = 'Error:' . curl_error($ch);
        }
        $results = json_decode($result);
        return $results->access_token;
    }
    public function paypal_withdraw()
    {
        removeTag($this->input->post());
        $user_currency = get_user_currency();
        $access_token  = $this->paypal_access_token();
        $params        = $this->input->post();
        if (empty($params['wallet_amt']) || empty($params['paypal_email'])) {
            $this->session->set_flashdata('msg_error', 'Wallet Amount or Email is Empty.');
            redirect('withdraw-wallet');
        }
        if ($this->paypal_option == 2) {
            $url = "https://api.paypal.com/v1/payments/payouts";
        } else {
            $url = "https://api.sandbox.paypal.com/v1/payments/payouts";
        }
        $unique = strtoupper(uniqid());
        $data   = ' {
  "sender_batch_header": {
    "sender_batch_id": "' . $unique . '",
    "email_subject": "You have a payout!",
    "email_message": "You have received a payout! Thanks for using our service!"
    },
    "items": [
    {
      "recipient_type": "EMAIL",
      "amount": {
        "value": "' . $params['wallet_amt'] . '",
        "currency": "' . $user_currency['user_currency_code'] . '"
        },
        "note": "Thanks for your Payout!",
        "sender_item_id": "' . $unique . '",
        "receiver":"' . $params['paypal_email'] . '"
      }
      ]
    }';
        $ch     = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $secretkey . ":" . $secretvalue);
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Bearer ' . $access_token // <---
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $result = 'Error:' . curl_error($ch);
        }
        $results = json_decode($result);
        if (!empty($results->batch_header->payout_batch_id)) {
            $user_id  = $this->session->userdata('SESSION_USER_ID');
            $pay_data = array(
                'user_id' => $user_id,
                'paypal_email' => $params['paypal_email'],
                'batch_id' => $results->batch_header->payout_batch_id,
                'withdraw_status' => $results->batch_header->batch_status,
                'amount' => $params['wallet_amt'],
                'currency' => $user_currency['user_currency_code'],
                'created_at' => date('Y-m-d H:i:s')
            );
            $this->db->insert('paypal_withdraw', $pay_data);
            $message = (!empty($this->user_language[$this->user_selected]['lg_withdraw_amount_success'])) ? $this->user_language[$this->user_selected]['lg_withdraw_amount_success'] : $this->default_language['en']['lg_withdraw_amount_success'];
            $this->session->set_flashdata('msg_success', $message);
            $this->session->set_flashdata('msg_success', 'Amount withdraw SuccessFully.');
            redirect('withdraw-wallet');
        } else {
            $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
            $this->session->set_flashdata('msg_error', $message);
            redirect('withdraw-wallet');
        }
    }
    public function check_paypal_status()
    {
        $access_token = $this->paypal_access_token();
        if ($this->paypal_option == 2) {
            $url = "https://api.paypal.com/v1/payments/payouts/";
        } else {
            $url = "https://api.sandbox.paypal.com/v1/payments/payouts/";
        }
        $paypal_status = $this->db->where('status', 0)->get('paypal_withdraw')->result_array();
        $urls          = '';
        if (count($paypal_status) > 0) {
            foreach ($paypal_status as $key => $value) {
                $urls = $url . $value['batch_id'];
                $ch   = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url . $value['batch_id']);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
                $headers = array(
                    'Content-Type:application/json',
                    'Authorization: Bearer ' . $access_token
                );
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    $result = 'Error:' . curl_error($ch);
                }
                $results = json_decode($result);
                if (!empty($results->batch_header)) {
                    if (!empty($results->items)) {
                        if ($results->items[0]->transaction_status == "SUCCESS") {
                            $wallet_tran = $this->Stripe_model->wallet_withdraw_history_flow($value['amount'], $value['currency'], $value['user_id'], $value['batch_id']);
                            if ($wallet_tran == true) {
                                $this->db->where('id', $value['id'])->update('paypal_withdraw', array(
                                    'status' => 1,
                                    'updated_at' => date('Y-m-d H:i:s')
                                ));
                            }
                        }
                    }
                }
            }
        }
    }
    public function transferir()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        $total_saldo = 0;
        if (!empty($params)) {

            $monto_transfer = $params['monto'];
            $usuario_a_transferir = $params['usuario'];
            $wallet_data = $this->Stripe_model->get_wallet($user_id);
            $wallet_history = $this->Stripe_model->get_wallet_history_info($user_id);


            $total_saldo = $wallet_data["wallet_amt"];


            if($total_saldo > $monto_transfer){

                $user_transferencia   = $this->db->where('email', $usuario_a_transferir)->get('members')->num_rows();

                if ($user_transferencia > 0) {

                    $user_det1   = $this->db->where('USERID', $user_id)->get('members')->row_array();
                    $user_det2   = $this->db->where('email', $usuario_a_transferir)->get('members')->row_array();


                    $wallet_data = array(
                        'user_id' => $user_id,
                        'amount' => $monto_transfer,
                        'currency_code' => $user_currency['user_currency_code'],
                        'status' => 1,
                        'transaction_status' => 1,
                        'request_payment' => "TRANSFER",
                        'created_by' => $user_id,
                        'created_at' => date('Y-m-d H:i:s'),
                        'user_receive' => $user_det2['USERID'],
                    );
                    $amount      = $this->db->insert('wallet_transfer', $wallet_data);
                    if ($amount == true) {
    

                        $amount_withdraw = $this->Stripe_model->wallet_transfer_flow($monto_transfer, $user_currency['user_currency_code'], $user_id, '', $user_det2['USERID']);
                    }

                    echo json_encode(array(
                        'status' => true,
                        'msg' => "Transferencia Completada.",
                        'saldo'=>$total_saldo
                    ));



                }else{

                    echo json_encode(array(
                        'status' => false,
                        'msg' => "No existe el usuario seleccionado."
                    ));

                }




            }else{

                echo json_encode(array(
                    'status' => false,
                    'msg' => "No tienes saldo suficiente"
                ));


            }
        }
    }
    public function transferirfc()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        $total_saldo = 0;
        if (!empty($params)) {

            $monto_transfer = $params['monto'];
            $wallet = $params['wallet'];
            $user_det1   = $this->db->where('USERID', $user_id)->get('members')->row_array();
            $wallet_user   = $this->db->where('favorcoin_address', $wallet)->get('members')->num_rows();

            if($wallet_user > 0){

                include APPPATH . 'classes/Favorcoin.php';
                $favorcoin = new Favorcoin('coinuser','coinpassword','208.85.18.35','6332');

                $wallet_balance = $favorcoin->getbalance($user_det1['favorcoin_address_username']);


                if($wallet_balance >= $monto_transfer){

                    $wallet_username = "fc_".$data['username'];
                    $favorcoin_operation = $favorcoin->sendfrom($user_det1['favorcoin_address_username'],$wallet,$monto_transfer);
    
                    $tx_data = array(
                        'txid' => $favorcoin_operation,
                        'created_at' => date('Y-m-d H:i:s'),
                        'descripcion' => 'Transferencia',
                    );
                    $save_data = $this->db->insert('favorcoin_transactions', $tx_data);
    
    
                        echo json_encode(array(
                            'status' => true,
                            'msg' => "Transferencia Completada. Se acreditara al tener suficientes confirmaciones."
                        ));


                }else{


                    echo json_encode(array(
                        'status' => false,
                        'msg' => "No tienes suficientes Favor Coins."
                    ));


                }
        
           



            }else{

                echo json_encode(array(
                    'status' => false,
                    'msg' => "Wallet no existe."
                ));



            }
        }
    }
    public function linkrequest()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        $total_saldo = 0;
        if (!empty($params)) {

            $user_det1   = $this->db->where('USERID', $user_id)->get('members')->row_array();

            $gig_id = $params['gig'];
            $mensaje = $params['mensaje'];
            $gig_query   = $this->db->where('id', $gig_id)->get('sell_gigs')->row_array();

            if(!empty($gig_query)){

                $user_gig = $gig_query["user_id"];

                $link_query   = $this->db->where('gig', $gig_id)->where('user_gig', $user_gig)->where('user_request', $user_id)->get('solicitud_referido')->row_array();

                if(!empty($link_query)){


                    echo json_encode(array(
                        'status' => false,
                        'msg' => "Ya hiciste una solicitud de referido por este artículo."
                    ));

                }else{


                    $link_data = array(
                        'gig' => $gig_id,
                        'user_gig' => $user_gig,
                        'user_request' => $user_id,
                        'message' => $mensaje,
                        'created_at' => date('Y-m-d H:i:s'),
                    );

                    $save_data = $this->db->insert('solicitud_referido', $link_data);

                    echo json_encode(array(
                        'status' => true,
                        'msg' => "Solicitud realizada, debes esperar su aprobacion."
                    ));

                }




            }else{

                echo json_encode(array(
                    'status' => false,
                    'msg' => "No se pudo procesar."
                ));


            }
        }
    }
    private function randomString() {

        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789!@#$%^&*_-";
    
        $pass = array(); //remember to declare $pass as an array
    
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    
        for ($i = 0; $i < 8; $i++) {
    
            $n = rand(0, $alphaLength);
    
            $pass[] = $alphabet[$n];
    
        }
    
        return implode($pass); //turn the array into a string
    
    }
    public function aprobarlink()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        $total_saldo = 0;
        if (!empty($params)) {
            $link_id = $params['link_id'];
            $codigo = $this->randomString();

            $data["link"] = $codigo;
            $data["estatus"] = 1;
            $data["updated_at"] = date("Y-m-d H:i:s");

            $this->db->where('id', $link_id);
            $this->db->update('solicitud_referido', $data);

            echo json_encode(array(
                'status' => true,
                'msg' => "Link Aprobado."
            ));
        }
    }
    public function anularlink()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        $total_saldo = 0;
        if (!empty($params)) {
            $link_id = $params['link_id'];

            $data["link"] = null;
            $data["estatus"] = 0;
            $data["updated_at"] = date("Y-m-d H:i:s");

            $this->db->where('id', $link_id);
            $this->db->update('solicitud_referido', $data);

            echo json_encode(array(
                'status' => true,
                'msg' => "Link Anulado."
            ));
        }
    }
    public function bank_details()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
        $user_currency = get_user_currency();
        if (!empty($params)) {
            $check_bank = $this->db->where('user_id', $user_id)->get('bank_account')->num_rows();
            $user_det   = $this->db->where('USERID', $user_id)->get('members')->row_array();
            $data       = array(
                'user_id' => $user_id,
                'account_number' => $params['account_no'],
                'account_holder_name' => $user_det['username'],
                'bank_name' => $params['bank_name'],
                'bank_address' => $params['bank_address'],
                'sort_code' => $params['sort_code'],
                'routing_number' => $params['routing_number'],
                'account_ifsc' => $params['ifsc_code'],
                'pancard_no' => $params['pancard_no'],
                'paypal_account' => $params['paypal_id'],
                'paypal_email_id' => $params['paypal_email_id']
            );
            if ($check_bank > 0) {
                $result = $this->db->where('user_id', $user_id)->update('stripe_bank_details', $data);
            } else {
                $result = $this->db->insert('stripe_bank_details', $data);
            }
            if ($result == true) {
                $wallet_data = array(
                    'user_id' => $user_id,
                    'amount' => $params['amount'],
                    'currency_code' => $user_currency['user_currency_code'],
                    'status' => 1,
                    'transaction_status' => 0,
                    'request_payment' => $params['payment_type'],
                    'created_by' => $user_id,
                    'created_at' => date('Y-m-d H:i:s')
                );
                $amount      = $this->db->insert('wallet_withdraw', $wallet_data);
                if ($amount == true) {
                    $amount_withdraw = $this->Stripe_model->wallet_withdraw_flow($params['amount'], $user_currency['user_currency_code'], $user_id, '');
                }
                $message = (!empty($this->user_language[$this->user_selected]['lg_amount_request_to_admin'])) ? $this->user_language[$this->user_selected]['lg_amount_request_to_admin'] : $this->default_language['en']['lg_amount_request_to_admin'];
                echo json_encode(array(
                    'status' => true,
                    'msg' => $message
                ));
            } else {
                $message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
                echo json_encode(array(
                    'status' => false,
                    'msg' => $message
                ));
            }
        }
    }
	public function razor_payment_success()
    { 
		
		removeTag($this->input->post());
        $params = $this->input->post();
        if (!empty($params)) {
            $amount        = $params['totalAmount'];
            $user_id       = $this->session->userdata('SESSION_USER_ID');
            $user          = $this->db->where('USERID', $user_id)->get('members')->row_array();
            $user_name     = $user['username'];
            $user_token    = $user['unique_code'];
            $currency_type = $user['currency_code'];
			$wallet = $this->db->where('user_provider_id', $user_id)->get('wallet_table')->row_array();
			$wallet_amt = $wallet['wallet_amt'];
			$history_pay['token']=$user_token;
			$history_pay['user_provider_id']=$user_id;
			$history_pay['currency_code']='INR';
			$history_pay['transaction_id']=$params['razorpay_payment_id'];
			$history_pay['paid_status']='';
			$history_pay['total_amt']=$this->input->post('totalAmount');
			if($wallet_amt){
				$current_wallet = $wallet_amt+$amount;
			}else{
				$current_wallet = $amount;
			}
			$history_pay['current_wallet']=$current_wallet;
			$history_pay['reason']='Add Wallet Amt';
			$history_pay['created_at']=date('Y-m-d H:i:s');
			$history_pay['credit_wallet']    = $amount;
            $history_pay['debit_wallet']     = 0;
			if($this->db->insert('wallet_transaction_history',$history_pay)){
				
				$this->db->where('user_provider_id', $user_id)->update('wallet_table', array(
					'currency_code' => 'INR',
					'wallet_amt' => $current_wallet
				));
				echo 0;                
			}else{
				echo 1;                
			}					
        }
		
    }
	public function razorthankyou(){
		$result = $_REQUEST['res'];
		if ($result == 0) {
			$message = (!empty($this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'])) ? $this->user_language[$this->user_selected]['lg_wallet_amount_add_wallet'] : $this->default_language['en']['lg_wallet_amount_add_wallet'];
			$this->session->set_flashdata('msg_success', $message);
			redirect('wallet');
		} else {
			$message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
			$this->session->set_flashdata('message', $message);
			redirect('wallet');
		}
	}
	public function razorpay_details()
    {
        removeTag($this->input->post());
        $params        = $this->input->post();
        $user_id       = $this->session->userdata('SESSION_USER_ID');
		$razorpay_option = $this->data['razorpay_option'];
		if($razorpay_option == 1){			
			$apikey = $this->data['razorpay_apikey'];
			$apisecret = $this->data['razorpay_apisecret'];
		}else if($razorpay_option == 2){
			$apikey = $this->data['razorpaylive_apikey'];
			$apisecret = $this->data['razorpaylive_apisecret'];
		}
        $user_currency = 'INR';
        if (!empty($params)) { 
			$url = "https://api.razorpay.com/v1/contacts";
			$unique = strtoupper(uniqid());
			$data   = ' {
			  "name":"'.$params['name'].'",
			  "email":"'.$params['email'].'",
			  "contact":"'.$params['contact'].'",
			  "type":"employee",
			  "reference_id":"'.$unique.'",
			  "notes":{}
			}';
			$ch     = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_USERPWD, $apikey . ":" . $apisecret);
			$headers = array(
				'Content-Type:application/json'
			);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			$result = curl_exec($ch);
			
			if (curl_errno($ch)) {
				$result = 'Error:' . curl_error($ch);
				echo json_encode(array(
                    'status' => false,
                    'msg' => $result
                ));
			}
			$results = json_decode($result);
			$user_id       = $this->session->userdata('SESSION_USER_ID');
			$cnotes = $results->notes;
			$serializedcnotes = serialize($cnotes);
			$contact_data = array(
				'user_id' => $user_id,
				'rp_contactid' => $results->id,
				'entity' => $results->entity,
				'name' => $results->name,
				'contact' => $results->contact,
				'email' => $results->email,
				'type' => $results->type,
				'reference_id' => $results->reference_id,
				'batch_id' => $results->batch_id,
				'active' => $results->active,
				'accountnumber' => $params['accountnumber'],
				'mode' => $params['mode'],
				'purpose' => $params['purpose'],
				'notes' => $serializedcnotes,
				'created_at' => $results->created_at
			);
			$createcontact = $this->db->insert('razorpay_contact', $contact_data);
			if(!empty($createcontact)){
				$faurl = "https://api.razorpay.com/v1/fund_accounts";
				$faunique = strtoupper(uniqid());
				$fadata   = ' {
				  "contact_id": "'.$results->id.'",
				  "account_type": "bank_account",
				  "bank_account": {
					"name": "'.$params['bank_name'].'",
					"ifsc": "'.$params['ifsc'].'",
					"account_number":"'.$params['accountnumber'].'"
				  }
				}';
								
				$fach     = curl_init();
				curl_setopt($fach, CURLOPT_URL, $faurl);
				curl_setopt($fach, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($fach, CURLOPT_POSTFIELDS, $fadata);
				curl_setopt($fach, CURLOPT_POST, 1);
				curl_setopt($fach, CURLOPT_USERPWD, $apikey . ":" . $apisecret);
				$faheaders = array(
					'Content-Type:application/json'
				);
				curl_setopt($fach, CURLOPT_HTTPHEADER, $faheaders);
				$faresult = curl_exec($fach);
				
				if (curl_errno($fach)) {
					$faresult = 'Error:' . curl_error($fach);
					echo json_encode(array(
						'status' => false,
						'msg' => $faresult
					));
				}
				$faresults = json_decode($faresult);
				
				$fa_data = array(
					'fund_account_id' => $faresults->id,
					'entity' => $faresults->entity,
					'contact_id' => $faresults->contact_id,
					'account_type' => $faresults->account_type,
					'ifsc' => $faresults->bank_account->ifsc,
					'bank_name' => $faresults->bank_account->bank_name,
					'name' => $faresults->bank_account->name,
					'account_number' => $faresults->bank_account->account_number,
					'active' => $faresults->active,
					'batch_id' => $faresults->batch_id,
					'created_at' => $faresults->created_at
				);
				$facreatecontact = $this->db->insert('razorpay_fund_account', $fa_data);
				
				if($facreatecontact){
					$purl = "https://api.razorpay.com/v1/payouts";
					$punique = strtoupper(uniqid());
					$pdata   = ' {
					  "account_number": "2323230032510196",
					  "fund_account_id": "'.$faresults->id.'",
					  "amount": "'.$params['amount'].'",
					  "currency": "INR",
					  "mode": "'.$params['mode'].'",
					  "purpose": "'.$params['purpose'].'",
					  "queue_if_low_balance": true,
					  "reference_id": "'.$punique.'",
					  "narration": "",
					  "notes": {}
					}';
					
					$pch     = curl_init();
					curl_setopt($pch, CURLOPT_URL, $purl);
					curl_setopt($pch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($pch, CURLOPT_POSTFIELDS, $pdata);
					curl_setopt($pch, CURLOPT_POST, 1);
					curl_setopt($pch, CURLOPT_USERPWD, $apikey . ":" . $apisecret);
					$pheaders = array(
						'Content-Type:application/json'
					);
					curl_setopt($pch, CURLOPT_HTTPHEADER, $pheaders);
					$presult = curl_exec($pch);
					
					if (curl_errno($pch)) {
						$presult = 'Error:' . curl_error($pch);						
						echo json_encode(array(
							'status' => false,
							'msg' => $presult
						));
					}
					$presults = json_decode($presult);
					
					$pydata = array(
						'payout_id' => $presults->id,
						'entity' => $presults->entity,
						'fund_account_id' => $presults->fund_account_id,
						'amount' => $presults->amount,
						'currency' => $presults->currency,
						'fees' => $presults->fees,
						'tax' => $presults->tax,
						'status' => $presults->status,
						'utr' => $presults->utr,
						'mode' => $presults->mode,
						'purpose' => $presults->purpose,						
						'reference_id' => $presults->reference_id,
						'narration' => $presults->narration,
						'batch_id' => $presults->batch_id,
						'failure_reason' => $presults->failure_reason,
						'created_at' => $presults->created_at
					);
					$payouts = $this->db->insert('razorpay_payouts', $pydata);
					if($payouts){
						$wdata = array(
							'user_id' => $user_id,
							'amount' => $presults->amount,
							'currency_code' => $presults->currency,
							'transaction_status' => 1,
							'transaction_date' => date('Y-m-d'),
							'request_payment' => 'RazorPay',
							'status' => 1,
							'created_by' => $user_id,
							'created_at' => $presults->created_at
						);
						$payoutins = $this->db->insert('wallet_withdraw', $wdata);
						if($payoutins){
							$amount        = $presults->amount;
							$user_id       = $this->session->userdata('SESSION_USER_ID');
							$user          = $this->db->where('USERID', $user_id)->get('members')->row_array();
							$user_name     = $user['username'];
							$user_token    = $user['unique_code'];
							$currency_type = $user['currency_code'];
							$wallet = $this->db->where('user_provider_id', $user_id)->get('wallet_table')->row_array();
							$wallet_amt = $wallet['wallet_amt'];
							$history_pay['token']=$user_token;
							$history_pay['user_provider_id']=$user_id;
							$history_pay['currency_code']='INR';
							$history_pay['transaction_id']=$presults->id;
							$history_pay['paid_status']='1';
							$history_pay['total_amt']=$presults->amount;
							if($wallet_amt){
								$current_wallet = $wallet_amt-$amount;
							}else{
								$current_wallet = $amount;
							}
							$history_pay['current_wallet']=$current_wallet;
							$history_pay['reason']='Withdrawn Wallet Amt';
							$history_pay['created_at']=date('Y-m-d H:i:s');
							if($this->db->insert('wallet_transaction_history',$history_pay)){								
								$this->db->where('user_provider_id', $user_id)->update('wallet_table', array(
									'currency_code' => 'INR',
									'wallet_amt' => $current_wallet
								));								               
							}
							$message = "Amount Withdrawn Successfully";
							echo json_encode(array(
								'status' => true,
								'msg' => $message
							));
						}else{
							$message = "Payout details not Inserted";
							echo json_encode(array(
								'status' => false,
								'msg' => $message
							));
						}
					}else{
						$message = "Payout details not Inserted";
						echo json_encode(array(
							'status' => false,
							'msg' => $message
						));
					}
				} 
			}
        }else{
			$message = (!empty($this->user_language[$this->user_selected]['lg_something_went_wrong'])) ? $this->user_language[$this->user_selected]['lg_something_went_wrong'] : $this->default_language['en']['lg_something_went_wrong'];
            echo json_encode(array(
                    'status' => false,
                    'msg' => $message
                ));
		}
    }
}
