<?php
class Follow extends CI_Controller
{
    public $data;
    public $website_email;
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->load->helper('custom_language');
        $this->load->helper('common_helper');
        $default_language_select = default_language();
        if ($this->session->userdata('user_select_language') == '') {
            $this->data['user_selected'] = $default_language_select['language_value'];
        } else {
            $this->data['user_selected'] = $this->session->userdata('user_select_language');
        }
        $this->data['active_language']  = $active_lang = active_language();
        $lg                             = custom_language($this->data['user_selected']);
        $this->data['default_language'] = $lg['default_lang'];
        $this->data['user_language']    = $lg['user_lang'];
        $this->user_selected            = (!empty($this->data['user_selected'])) ? $this->data['user_selected'] : 'en';
        $this->default_language         = (!empty($this->data['default_language'])) ? $this->data['default_language'] : '';
        $this->user_language            = (!empty($this->data['user_language'])) ? $this->data['user_language'] : '';
        $this->load->helper('favourites');
        $common_settings  = gigs_settings();
        $default_currency = 'USD';
        if (!empty($common_settings)) {
            foreach ($common_settings as $datas) {
                if ($datas['key'] == 'currency_option') {
                    $default_currency = $datas['value'];
                }
            }
        }
        $this->load->helper('currency');
        $this->default_currency      = $default_currency;
        $this->default_currency_sign = currency_sign($default_currency);
        $this->smtp_config           = smtp_mail_config();
        $query                       = $this->db->query("select * from system_settings WHERE status = 1");
        $result                      = $query->result_array();
        $this->email_address         = 'mail@example.com';
        $this->email_tittle          = 'Gigs';
        $this->logo_front            = base_url() . 'assets/img/logo.png';
        if (!empty($result)) {
            foreach ($result as $data) {
                if ($data['key'] == 'email_address') {
                    $this->email_address = !empty($data['value']) ? $data['value'] : 'mail@example.com';
                }
                if ($data['key'] == 'email_tittle') {
                    $this->email_tittle = !empty($data['value']) ? $data['value'] : 'Gigs';
                }
                if ($data['key'] == 'base_domain') {
                    $this->base_domain = $data['value'];
                }
                if ($data['key'] == 'logo_front') {
                    if($data['value'] != '' && file_exists($data['value'])) {
						$this->logo_front = base_url() . $data['value'];
					}
                }
                if ($data['key'] == 'site_name' || $data['key'] == 'website_name') {
                    $this->site_name = $data['value'];
                }
            }
        }
        $this->data['module'] = 'user';
        $this->load->model('user_panel_model');
        $this->load->model('follow_to_model');
        $this->load->model('templates_model');
        if (empty($this->session->userdata('timezone'))) {
            $this->session->set_userdata('timezone', 'Asia/Kolkata');
        }
    }
    public function index()
    {
    }

    public function settings()
    {
        $this->db->select('key, value');
        $this->db->from('system_settings');
        $records = $this->db->get()->result_array();
        $array   = array();
        foreach ($records as $value) {
            if ($value['key'] == 'one_signal_subdomain') {
                $array['one_signal_subdomain'] = $value['value'];
            }
            if ($value['key'] == 'one_signal_app_id') {
                $array['one_signal_app_id'] = $value['value'];
            }
            if ($value['key'] == 'one_signal_reset_key') {
                $array['one_signal_reset_key'] = $value['value'];
            }
        }
        return $array;
    }
    public function save_follow()
    {
        removeTag($this->input->post());
        $profile_id      = $this->input->post('profile_id');
        $user_id      = $this->input->post('user_id');
        $date               = date("Y-m-d H:i:s");


        $followed = $this->follow_to_model->check_followed($user_id ,$profile_id);

        if($followed == 0){

            $data["user_id"] = $user_id;
            $data["follow_to"] = $profile_id;
            $data["created_at"] = $date;
            $this->db->insert('follow_to', $data);

        }else{


        }


        return 1;
       
   
    }
}
