<?php
class Dashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->load->library('Encryption', 'encrypt');
        $this->load->helper('custom_language');
        $this->load->helper('common_helper');
        $default_language_select = default_language();
        if ($this->session->userdata('user_select_language') == '') {
            $this->data['user_selected'] = $default_language_select['language_value'];
        } else {
            $this->data['user_selected'] = $this->session->userdata('user_select_language');
        }
        $this->data['active_language']  = $active_lang = active_language();
        $lg                             = custom_language($this->data['user_selected']);
        $this->data['default_language'] = $lg['default_lang'];
        $this->data['user_language']    = $lg['user_lang'];
        $this->user_selected            = (!empty($this->data['user_selected'])) ? $this->data['user_selected'] : 'en';
        $this->default_language         = (!empty($this->data['default_language'])) ? $this->data['default_language'] : '';
        $this->user_language            = (!empty($this->data['user_language'])) ? $this->data['user_language'] : '';
        $this->load->helper('favourites');
        $common_settings  = gigs_settings();
        $default_currency = 'USD';
        if (!empty($common_settings)) {
            foreach ($common_settings as $datas) {
                if ($datas['key'] == 'currency_option') {
                    $default_currency = $datas['value'];
                }
            }
        }
        $this->load->helper('currency');
        $this->default_currency      = $default_currency;
        $this->default_currency_sign = currency_sign($default_currency);
        $this->smtp_config           = smtp_mail_config();
        $this->data['theme']         = 'user';
        $this->data['module']        = 'dashboard';
        $this->load->model('user_login_model');
        $this->load->model('user_panel_model');
        $this->data['client_list']              = $this->user_panel_model->get_client_list();
        $this->data['categories_subcategories'] = $this->user_panel_model->categories();
        $this->data['footer_main_menu']         = $this->user_panel_model->footer_main_menu();
        $this->data['footer_sub_menu']          = $this->user_panel_model->footer_sub_menu();
        $this->data['system_setting']           = $this->user_panel_model->system_setting();
        $this->data['policy_setting']           = $this->user_panel_model->policy_setting();
        $this->load->model('gigs_model');
        $query               = $this->db->query("select * from system_settings WHERE status = 1");
        $result              = $query->result_array();
        $this->email_address = 'mail@example.com';
        $this->email_tittle  = 'Gigs';
        $this->logo_front    = base_url() . 'assets/img/logo.png';
        $this->site_name     = 'gigs';
        $this->base_domain   = base_url();
        if (!empty($result)) {
            foreach ($result as $data) {
                if ($data['key'] == 'email_address') {
                    $this->email_address = !empty($data['value']) ? $data['value'] : 'mail@example.com';
                }
                if ($data['key'] == 'email_tittle') {
                    $this->email_tittle = !empty($data['value']) ? $data['value'] : 'Gigs';
                }
				if ($data['key'] == 'mail_config') {
                    $this->mail_config = $data['value'];
                }
				if ($data['key'] == 'smtp_email_address') {
                    $this->smtp_email_address = $data['value'];
                }
				
				
				
                if ($data['key'] == 'logo_front') {
                    if($data['value'] != '' && file_exists($data['value'])) {
						$this->logo_front = base_url() . $data['value'];
					}
                }
                if ($data['key'] == 'site_name' || $data['key'] == 'website_name') {
                    $this->site_name = $data['value'];
                }
                $this->data['currency_option'] = 'USD';
                if ($data['key'] == 'currency_option') {
                    $this->data['currency_option'] = $data['value'];
                }
            }
        }
        $this->data['recent_gigs']     = $this->gigs_model->recent_gigs();
        $this->data['gig_price']       = $this->gigs_model->gig_price();
        $this->data['extra_gig_price'] = $this->gigs_model->gig_price();
        $this->data['logo']            = $this->user_panel_model->get_logo();
        $this->data['slogan']          = $this->user_panel_model->get_slogan();
    }
    public function index()
    {
        $this->data['page'] = 'index';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '');
    }
    public function is_valid_login()
    {
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        $result   = $this->user_login_model->check_login($username, $password);
        if (!empty($result)) {
            if ($result['verified'] == 0 && $result['status'] == 0) {
                $this->session->set_userdata('SESSION_USER_ID', $result['USERID']);
                $this->session->set_userdata('user_role', 2);
                $this->session->set_userdata('old_timezone', $result['user_timezone']);
                $this->session->set_userdata('unique_code', $result['unique_code']);
                echo 1;
            } else {
                if ($result['status'] == 1 && $result['verified'] == 0) {
                    echo 3;
                } else {
                    echo 2;
                }
            }
        } else {
            echo 0;
        }
    }
    public function check_username_availability()
    {
        $username = $this->input->get('username');
        $result   = $this->user_panel_model->check_username($username);
        if ($result > 0) {
            $isAvailable = FALSE;
        } else {
            $isAvailable = TRUE;
        }
        echo json_encode(array(
            'valid' => $isAvailable
        ));
    }
    public function check_registered_email()
    {
        $email  = $this->input->post('forget_email');
        if(!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $email)) {
            $isAvailable = FALSE;
        }
        else {
            $result = $this->user_panel_model->check_email($email);
        if ($result > 0) {
            $isAvailable = TRUE;
        } else {
            $isAvailable = FALSE;
        }
    }
        echo json_encode(array(
            'valid' => $isAvailable
        ));
    }
    public function extra_gig_calculations()
    {
        removeTag($this->input->post());
        $extra_gigs_details          = $this->input->post('extra_gigs_details');
        $gig_id                      = $this->input->post('gig_id');
        $user_id                     = $this->session->userdata('SESSION_USER_ID');
        $currency_type               = $this->input->post('currency_type');
        $gig_details                 = $this->gigs_model->extra_gig_calculations($gig_id);
        $rupee_rate                  = $this->session->userdata('rupee_rate');
        $country_name                = $this->session->userdata('country_name');
        $dollar_rate                 = $this->session->userdata('dollar_rate');
        $super_fast_delivery         = $this->input->post('super_fast_delivery');
        $super_fast_delivery_charges = $this->input->post('super_fast_delivery_charges');
        $super_fast_desc             = $this->input->post('super_fast_desc');
        $extra_gig_rate_symbol       = $this->input->post('rate_symbol');
        $super_fast_delivery_date    = $this->input->post('super_fast_delivery_date');
        $gig_price                   = $this->gigs_model->gig_price();
        $gig_price1                  = $gig_price['value'];
        $gig_price1                  = $gig_details['gig_price'];
        $user_currency               = get_user_currency();
        $user_currency_code          = $user_currency['user_currency_code'];
        $user_currency_rate          = $user_currency['user_currency_rate'];
        $currency_option             = (!empty($user_currency_code)) ? $user_currency_code : 'USD';
        $rate_symbol                 = currency_conversion($currency_option);
        if ($user_currency_code == $gig_details['currency_type']) {
            $gig_price1 = round($gig_details['gig_price'], 2);
        }
        if ($gig_details['currency_type'] == 'USD' && $user_currency_code != 'USD') {
            $gig_price1 = round($gig_details['gig_price'] * $user_currency_rate, 2); // Dyanamic Price 
        }
        if ($gig_details['currency_type'] != 'USD') {
            if ($gig_details['currency_type'] == $user_currency_code) {
                $gig_price1 = round($gig_details['gig_price'], 2);
            } else {
                $gig_price1 = get_gigs_currency($gig_details['gig_price'], $gig_details['currency_type'], $user_currency_code);
            }
        }
        $rate        = $gig_details['gig_price'];
        $super_class = "total_cost_active";
        if ($super_fast_delivery == 'yes') {
            $super_class                 = "total_cost_deactive";
            $super_fast_delivery_charges = ($super_fast_delivery_charges);
        }
		$gigimage = "assets/img/gig-small.jpg";
		if (!empty($gig_details['gig_image']) && file_exists($gig_details['gig_image'])) {
			$gigimage = $gig_details['gig_image'];
		}
        $item                  = (!empty($this->user_language[$this->user_selected]['lg_item'])) ? $this->user_language[$this->user_selected]['lg_item'] : $this->default_language['en']['lg_item'];
        $product_name          = (!empty($this->user_language[$this->user_selected]['lg_product_name'])) ? $this->user_language[$this->user_selected]['lg_product_name'] : $this->default_language['en']['lg_product_name'];
        $quantity              = (!empty($this->user_language[$this->user_selected]['lg_quantity'])) ? $this->user_language[$this->user_selected]['lg_quantity'] : $this->default_language['en']['lg_quantity'];
        $to_tal                = (!empty($this->user_language[$this->user_selected]['lg_total'])) ? $this->user_language[$this->user_selected]['lg_total'] : $this->default_language['en']['lg_total'];
        $html                  = '';
        $html_table_header     = '<div class="table-responsive">
                            <table class="table table-bordered">
                              <thead>
                                <tr>
                                  <th>' . $item . '</th>
                                  <th>' . $product_name . '</th>
                                  <th class="text-center">' . $quantity . '</th>
                                  <th class="text-right">' . $to_tal . '</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr class="' . $super_class . '" >
                                  <td><img src="' . base_url() . $gigimage . '" width="50" height="34"></td>
                                  <td>
                                    <a class="product_name text-ellipsis" href="javascript:;">' . ucfirst(str_replace("-", " ", $gig_details['title'])) . '</a>
                                  </td>
                                  <td> 1 </td>
                                  <td class="total">' . $rate_symbol . $gig_price1 . '</td>
                                </tr>';
        $html_table_contents   = '';
        $html_table_footer     = '</tbody>
                            </table>
                            </div>';
        $extra_gig_inserted_id = array();
        $calculation_table     = '';
        if (!empty($extra_gigs_details)) {
            foreach ($extra_gigs_details as $extras) {
                $gig_values = explode('___', $extras);
                if ($gig_values[1] != 0 || $gig_values[1] != "undefined") {
                    $data['gig_id']        = $gig_id;
                    $data['user_id']       = $user_id;
                    $data['options']       = json_encode($extras);
                    $data['status']        = 1;
                    $data['currency_type'] = $currency_type;
                    $html_table_contents .= '<tr>
                                            <td> &nbsp; </td>
                                            <td><span class="text-ellipsis">' . $gig_values[0] . '</span></td>
                                            <td>' . $gig_values[1] . '</td>
                                            <td class="total">' . $rate_symbol . $gig_values[2] . '</td>
                                          </tr>';
                    $this->db->insert('user_required_extra_gigs', $data);
                    $extra_gig_inserted_id[] = $this->db->insert_id();
                }
            }
        }
        if (($super_fast_delivery == 'yes')) {
            if (empty($super_fast_desc)) {
                $super_fast_desc = "super fast delivery";
            }
            $html_table_contents .= '<tr>
                                        <td> <span class="super-fast">Super Fast</span> </td>
                                        <td>' . $super_fast_desc . '</td>
                                        <td>1</td>
                                        <td class="total">' . $rate_symbol . $super_fast_delivery_charges . '</td>
                                      </tr>';
        }
        $calculation_table = $html_table_header . $html_table_contents . $html_table_footer;
        echo json_encode(array(
            'html' => $calculation_table,
            'sub_html' => $extra_gig_inserted_id,
            'rate_symbol' => $rate_symbol,
            'super_fast_delivery' => $super_fast_delivery,
            'super_fast_delivery_charges' => $super_fast_delivery_charges
        ));
    }
    public function check_gig_title()
    {
        $title      = str_replace(" ", "-", trim($this->input->post('gig_title')));
        $append_sql = '';
        $gig_id     = $this->input->post('gig_id');
        if (!empty($gig_id)) {
            $append_sql = "AND id != " . $gig_id . "";
        }
        $query  = $this->db->query("SELECT * FROM `sell_gigs` WHERE `title` = '$title' " . $append_sql . ";");
        $result = $query->num_rows();
        if ($result > 0) {
            $isAvailable = FALSE;
        } else {
            $isAvailable = TRUE;
        }
        echo json_encode(array(
            'valid' => $isAvailable
        ));
    }
    public function check_username()
    {
        $username = $this->input->post('username');
        $result   = $this->user_panel_model->check_username($username);
        if ($result > 0) {
            $isAvailable = FALSE;
        } else {
            $isAvailable = TRUE;
        }
        echo json_encode(array(
            'valid' => $isAvailable
        ));
    }
    public function check_available_email()
    {
        $email  = $this->input->post('forget_email');
        $result = $this->user_panel_model->check_email($email);
        if ($result > 0) {
            $isAvailable = FALSE;
        } else {
            $isAvailable = TRUE;
        }
        echo json_encode(array(
            'valid' => $isAvailable
        ));
    }
    public function activate_account()
    {
		
        if ($this->uri->segment(2))
            $user_name = $this->uri->segment(2);//
       // $username = $this->encryptor('decrypt', $user_name);//echo $username;exit;
        $username =urldecode($user_name);//echo $username;exit;
        if (!empty($username)) {
            $data['verified'] = 0;
            $data['status']   = 0;
            $this->db->update('members', $data, array(
                'username' => $username
            ));
            $this->session->set_userdata('users_account_activate', "success");
            redirect(base_url());
        }
        redirect(base_url());
    }
    public function change_password()
    {
        removeTag($this->input->post());
        if ($this->uri->segment(2))
            $user_name = trim($this->uri->segment(2));
        $query = $this->db->query("select USERID,forget from `members` where forget='$user_name'");
        $num   = $query->num_rows();
        if ($num != 0) {
            $user_det = $query->row_array();
            //$username = $this->encryptor('decrypt', $user_name);
            $username = urldecode($user_name);
            if ($this->input->post('form_submit')) {
                $data['password'] = $this->encryption->encrypt($this->input->post('new_password'));
                $data['forget']   = '';
                $this->db->where('USERID', $user_det['USERID']);
                $this->db->update('members', $data);
                $message = (!empty($this->user_language[$this->user_selected]['lg_the_password_updated__successfully_please_login_again'])) ? $this->user_language[$this->user_selected]['lg_the_password_updated__successfully_please_login_again'] : $this->default_language['en']['lg_the_password_updated__successfully_please_login_again'];
                $this->session->set_flashdata('message', $message);
                redirect(base_url());
            }
        } else {
            $message = (!empty($this->user_language[$this->user_selected]['lg_the_email_has_been_expired'])) ? $this->user_language[$this->user_selected]['lg_the_email_has_been_expired'] : $this->default_language['en']['lg_the_email_has_been_expired'];
            $this->session->set_flashdata('message', $message);
            redirect(base_url());
        }
        if (!empty($username)) {
            $this->data['title']      = $this->email_tittle;
            $this->data['page_title'] = 'Change Password';
            $this->data['username']   = $username;
            $this->data['page']       = 'forget_password';
            $this->data['module']     = 'dashboard';
            $this->load->vars($this->data);
            $this->load->view($this->data['theme'] . '/template');
        }
    }
    function encryptor($action, $string)
    {
        $output         = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key     = 'muni';
        $secret_iv      = 'muni123';
        $key            = hash('sha256', $secret_key);
        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv             = substr(hash('sha256', $secret_iv), 0, 16);
        //do the encyption given text/string/number
        if ($action == 'encrypt') {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if ($action == 'decrypt') {
            //decrypt the given text/string/number
            $output = openssl_decrypt($string, $encrypt_method, $key, 0, $iv);
			$output = base64_decode($output);
        }
        return $output;
    }
    public function users_registeration()
    {
        removeTag($this->input->post());
        if (($this->session->userdata('time_zone'))) {
            $this->data['time_zone']         = $this->session->userdata('time_zone');
            $this->data['full_country_name'] = $this->session->userdata('full_country_name');;
            $this->data['country_name'] = $this->session->userdata('country_name');;
        } else {
            $user_ip                         = getenv('REMOTE_ADDR');
            $geo                             = unserialize(file_get_contents("http://www.geoplugin.net/php.gp?ip=$user_ip"));
            $geoplugin_latitude              = $geo["geoplugin_latitude"];
            $geoplugin_longitude             = $geo["geoplugin_longitude"];
            $t                               = time();
            $result                          = $this->getTimezoneGeo($geoplugin_latitude, $geoplugin_longitude, $t);
            $this->data['time_zone']         = $result;
            $this->data['full_country_name'] = $geo['geoplugin_countryName'];
            $this->data['country_name']      = $geo['geoplugin_countryCode'];
            $this->data['dollar_rate']       = 74.78;
            $this->data['rupee_rate']        = (1 / $this->data['dollar_rate']);
            $newdata                         = array(
                'country_name' => $geo['geoplugin_countryCode'],
                'time_zone' => $result,
                'full_country_name' => $geo['geoplugin_countryName']
            );
            $this->session->set_userdata($newdata);
        }
        $data['username']      = $this->input->post('username');
        $data['password']      = $this->encryption->encrypt($this->input->post('password'));
        $data['email']         = $this->input->post('email');
        $data['fullname']      = ucfirst($this->input->post('name'));
        $data['country']       = $this->input->post('country_id');
        $data['state']         = $this->input->post('state_id');
        $data['user_timezone'] = $this->data['time_zone'];
        date_default_timezone_set($data['user_timezone']);
        $data['created_date']   = date('Y-m-d H:i:s');
        $data['verified']       = 1;
        $data['reference_code'] = rand(10, 1000000);
        $data['status']         = 1;
        include APPPATH . 'classes/Favorcoin.php';
        $favorcoin = new Favorcoin('coinuser','coinpassword','208.85.18.35','6332');

        $wallet_username = "fc_".$data['username'];
        $wallet_address = $favorcoin->getnewaddress($wallet_username);

        $data['favorcoin_address'] 	= $wallet_address;
        $data['favorcoin_address_username'] 	= $wallet_username;
        $data['referido_por'] 	= "";
        
       

        if ($this->session->userdata('codigo_referido')) { 

            $codigo_referido = $this->session->userdata('codigo_referido');

            $query  = $this->db->query("SELECT * FROM `members` WHERE `reference_code` = '$codigo_referido';");
            $result = $query->row_array();
            if (!empty($result)) {

                $query_check_cantidad_referidos  = $this->db->query("SELECT * FROM `members` WHERE `referido_por` = '$codigo_referido';");
               
                if ($query_check_cantidad_referidos->num_rows() < 5) {

                    $referido_wallet = $result["favorcoin_address"];
                    $query_settings              = $this->db->query("select * from system_settings WHERE status = 1");
                    $result_settings             = $query_settings->result_array();
                    if (!empty($result_settings)) {
                        foreach ($result_settings as $datas) {
                            if ($datas['key'] == 'site_name' || $datas['key'] == 'favorcoin_registro') {
                                $this->favorcoin_registro         = $datas['value'];
                                $this->data['favorcoin_registro'] = $this->favorcoin_registro;
                            }
                        }
                    }

                    $recompensa = $this->favorcoin_registro;
                    $favorcoin_operation = $favorcoin->sendtoaddress($referido_wallet,$recompensa);
    
                    $tx_data = array(
                        'txid' => $favorcoin_operation,
                        'created_at' => date('Y-m-d H:i:s'),
                        'descripcion' => 'Recompensa',
                    );
                    $save_data = $this->db->insert('favorcoin_transactions', $tx_data);

                    $data['referido_por'] 	= $codigo_referido;

                }


            }


            $this->session->unset_userdata('codigo_referido');
        }

        if ($this->db->insert('members', $data)) {
            $user_id     = $this->db->insert_id();
            $wallet_data = array(
                'token' => '',
                'user_provider_id' => $user_id,
                'type' => 1,
                'wallet_amt' => 0,
                'reason' => '',
                'created_at' => date('Y-m-d H:i:s')
            );
            $this->db->insert('wallet_table', $wallet_data);
            $user_reference_code = rand(10, 1000000);
            $user_upate          = $this->db->where('USERID', $insert)->update('members', array(
                'reference_code' => $user_reference_code
            ));
            $username            = $data['username'];
            //$url_encypted        = urlencode($this->encryptor('encrypt', $username));
            $url_encypted        = urlencode($username);
            $url                 = base_url() . 'activate_account/' . $url_encypted;
            $this->load->model('templates_model');
            $message          = '';
            $welcomemessage   = '';
            $bodyid           = 13;
            $tempbody_details = $this->templates_model->get_usertemplate_data($bodyid);
            $body             = $tempbody_details['template_content'];
            $body             = str_replace('{base_url}', $this->base_domain, $body);
            $body             = str_replace('{base_image}', $this->base_domain . '/' . $this->logo_front, $body);
            $body             = str_replace('{USER_NAME}', $username, $body);
            $body             = str_replace('{sitetitle}', $this->site_name, $body);
            $body             = str_replace('{SUBMIT_LINK}', $url, $body);
            $message          = '<table style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; background-color: #f6f6f6; margin: 0;" bgcolor="#f6f6f6">
                                  <tr>
                                    <td></td>
                                    <td width="600" style="box-sizing: border-box; vertical-align: top; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto;" valign="top">
                                      <div style="box-sizing: border-box; max-width: 600px; display: block; margin: 0 auto; padding: 20px;">
                                        <table width="100%" cellpadding="0" cellspacing="0" style="box-sizing: border-box; font-size: 14px; border-radius: 3px; background-color: #fff; margin: 0; border: 1px solid #e9e9e9;" bgcolor="#fff">
                                          <tr>
                                            <td style="box-sizing: border-box; vertical-align: top; text-align: left; margin: 0; padding: 20px;" valign="top">
                                              <table width="100%" cellpadding="0" cellspacing="0">
                                                <tr>
                                                  <td style="text-align:center;">
                                                    <a href="{base_url}" target="_blank"><img src="' . $this->logo_front . '" style="width:90px" /></a>
                                                  </td>
                                                </tr>
                                                <tr>
                                                  <td>' . $body . '</td>
                                                </tr>
                                              </table>
                                            </td>
                                          </tr>
                                        </table>
                                        <div style="box-sizing: border-box; width: 100%; clear: both; color: #999; margin: 0; padding: 15px 15px 0 15px;">
                                          <table width="100%">
                                            <tr>
                                              <td style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 12px; vertical-align: top; color: #999; text-align: center; margin: 0; padding: 0;" align="center" valign="top">
                                                &copy; ' . date("Y") . ' <a href="' . $this->base_domain . '" target="_blank" style="color:#bbadfc;" target="_blank">' . $this->site_name . '</a> All Rights Reserved.
                                              </td>
                                            </tr>
                                          </table>
                                        </div>
                                      </div>
                                    </td>
                                  </tr>
                                </table>';
								
								// echo $this->smtp_email;
								// echo $this->email_tittle;
								// exit;
								
			$phpmail_config =  $this->mail_config;//
            if (isset($phpmail_config) && !empty($phpmail_config)) {
                if ($phpmail_config == "phpmail") {
                    $from_email = $this->email_address;
                } else {
                    $from_email = $this->smtp_email_address;
                }
            }
			
			//$this->load->helper('file');
            $this->load->library('email');	
			//print_r($this->smtp_config);exit;
            if (!empty($from_email) && isset($from_email)) {
				 // $this->email->initialize($this->smtp_config);
				
                // $this->email->set_newline("\r\n");
                $mail = $this->email
                        ->from($from_email)
                        ->to($data['email'])
                        ->subject('Welcome and thank you for joining ' . $this->site_name)
                        ->message($message)
                        ->send();
					
					
					
            }
			 //echo $this->email->print_debugger();

			//print_r($mail);exit;
				//
            if ($mail) {
                $this->session->set_userdata("user_registeration", "Success");
                echo 1;
            } else {
                echo 0;
            }
        } else {
            echo 2;
        }
    }
    private function randomPassword()
    {
        $alphabet    = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789!@#$%^&*_-";
        $pass        = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n      = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }
    public function sociallogin_registration()
    {
        removeTag($this->input->post());
        if (($this->session->userdata('time_zone'))) {
            $this->data['time_zone']         = $this->session->userdata('time_zone');
            $this->data['full_country_name'] = $this->session->userdata('full_country_name');;
            $this->data['country_name'] = $this->session->userdata('country_name');;
        } else {
            $user_ip                         = getenv('REMOTE_ADDR');
            $geo                             = unserialize(file_get_contents("http://www.geoplugin.net/php.gp?ip=$user_ip"));
            $geoplugin_latitude              = $geo["geoplugin_latitude"];
            $geoplugin_longitude             = $geo["geoplugin_longitude"];
            $t                               = time();
            $result                          = $this->getTimezoneGeo($geoplugin_latitude, $geoplugin_longitude, $t);
            $this->data['time_zone']         = $result;
            $this->data['full_country_name'] = $geo['geoplugin_countryName'];
            $this->data['country_name']      = $geo['geoplugin_countryCode'];
            $this->data['dollar_rate']       = 67.08;
            $this->data['rupee_rate']        = (1 / $this->data['dollar_rate']);
            $newdata                         = array(
                'country_name' => $geo['geoplugin_countryCode'],
                'time_zone' => $result,
                'full_country_name' => $geo['geoplugin_countryName']
            );
            $this->session->set_userdata($newdata);
        }
        $password   = $this->randomPassword();
        $email      = $this->input->post('email');
        $auth       = $this->input->post('auth');
        $profileurl = $this->input->post('profileurl');
        $emails     = strstr($email, '@', true);
        $username   = str_replace(' ', '-', $emails);
        if ($auth == 'Google') {
            $username = preg_replace('/[^A-Za-z0-9\-]/', '', $username . 'gp');
        }
        if ($auth == 'Facebook') {
            $username = preg_replace('/[^A-Za-z0-9\-]/', '', $username . 'fb');
        }
        if (!empty($profileurl)) {
            $content = file_get_contents($profileurl);
            $fp      = fopen("uploads/profile_images/" . $username . "", "w");
            fwrite($fp, $content);
        }
        $already_social_login = $this->user_login_model->check_already_social_login($this->input->post('email'), $this->input->post('profileid'));
        if ($already_social_login) {
            $data['fullname'] = ucfirst($this->input->post('fullname'));
            if ($auth == 'Google') {
                $data['google_id'] = $this->input->post('profileid');
            }
            if ($auth == 'Facebook') {
                $data['facebook_id'] = $this->input->post('profileid');
            }
            if (!empty($profileurl)) {
                $data['profileurl']         = $this->input->post('profileurl');
                $data['user_profile_image'] = 'uploads/profile_images/' . $username;
                $data['user_thumb_image']   = 'uploads/profile_images/' . $username;
            }
            $data['user_timezone'] = $this->data['time_zone'];
            date_default_timezone_set($data['user_timezone']);
            $data['created_date'] = date('Y-m-d H:i:s');
            $data['verified']     = 0;
            $data['status']       = 0;
            $this->db->where('USERID', $already_social_login['USERID']);
            if ($this->db->update('members', $data)) {
                $results = $this->user_login_model->check_social_login($already_social_login['USERID']);
                $this->session->set_userdata('SESSION_USER_ID', $results['USERID']);
                $this->session->set_userdata('user_role', 2);
                $this->session->set_userdata('old_timezone', $results['user_timezone']);
                $this->session->set_userdata('unique_code', $results['unique_code']);
                echo 1;
            } else {
                echo 0;
            }
        } else {
            $data['username'] = $username;
            $data['password'] = $this->encryption->encrypt($password);
            $data['email']    = $this->input->post('email');
            $data['fullname'] = ucfirst($this->input->post('fullname'));
            if ($auth == 'Google') {
                $data['google_id'] = $this->input->post('profileid');
            }
            if ($auth == 'Facebook') {
                $data['facebook_id'] = $this->input->post('profileid');
            }
            if (!empty($profileurl)) {
                $data['profileurl']         = $this->input->post('profileurl');
                $data['user_profile_image'] = 'uploads/profile_images/' . $username;
                $data['user_thumb_image']   = 'uploads/profile_images/' . $username;
            }
            $data['user_timezone'] = $this->data['time_zone'];
            date_default_timezone_set($data['user_timezone']);
            $data['created_date']   = date('Y-m-d H:i:s');
            $data['verified']       = 0;
            $data['status']         = 0;
            $data['reference_code'] = rand(10, 1000000);
            include APPPATH . 'classes/Favorcoin.php';
            $favorcoin = new Favorcoin('coinuser','coinpassword','208.85.18.35','6332');
    
            $wallet_username = "fc_".$data['username'];
            $wallet_address = $favorcoin->getnewaddress($wallet_username);
    
            $data['favorcoin_address'] 	= $wallet_address;
            $data['favorcoin_address_username'] 	= $wallet_username;
            $data['referido_por'] 	= "";
        
       

            if ($this->session->userdata('codigo_referido')) { 
    
                $codigo_referido = $this->session->userdata('codigo_referido');
    
                $query  = $this->db->query("SELECT * FROM `members` WHERE `reference_code` = '$codigo_referido';");
                $result = $query->row_array();
                if (!empty($result)) {
    
                    $query_check_cantidad_referidos  = $this->db->query("SELECT * FROM `members` WHERE `referido_por` = '$codigo_referido';");
                   
                    if ($query_check_cantidad_referidos->num_rows() < 5) {
    
                        $referido_wallet = $result["favorcoin_address"];
                        $query_settings              = $this->db->query("select * from system_settings WHERE status = 1");
                        $result_settings             = $query_settings->result_array();
                        if (!empty($result_settings)) {
                            foreach ($result_settings as $datas) {
                                if ($datas['key'] == 'site_name' || $datas['key'] == 'favorcoin_registro') {
                                    $this->favorcoin_registro         = $datas['value'];
                                    $this->data['favorcoin_registro'] = $this->favorcoin_registro;
                                }
                            }
                        }
    
                        $recompensa = $this->favorcoin_registro;
                        $favorcoin_operation = $favorcoin->sendtoaddress($referido_wallet,$recompensa);
        
                        $tx_data = array(
                            'txid' => $favorcoin_operation,
                            'created_at' => date('Y-m-d H:i:s'),
                            'descripcion' => 'Recompensa',
                        );
                        $save_data = $this->db->insert('favorcoin_transactions', $tx_data);
    
                        $data['referido_por'] 	= $codigo_referido;
    
                    }
    
    
                }
    
    
                $this->session->unset_userdata('codigo_referido');
            }
            if ($this->db->insert('members', $data)) {
                $user_id = $this->db->insert_id();
                $this->db->insert('wallet_table', array(
                    'token' => '',
                    'user_provider_id' => $user_id,
                    'type' => 1,
                    'reason' => 'user_wallet',
                    'wallet_amt' => 0,
                    'created_at' => date('Y-m-d H:i:s')
                ));
                $last_update_id = $this->db->insert_id();
                $results        = $this->user_login_model->check_social_login($last_update_id);
                $this->session->set_userdata('SESSION_USER_ID', $results['USERID']);
                $this->session->set_userdata('user_role', 2);
                $this->session->set_userdata('old_timezone', $results['user_timezone']);
                $this->session->set_userdata('unique_code', $results['unique_code']);
                $this->load->model('templates_model');
                $message          = '';
                $welcomemessage   = '';
                $bodyid           = 35;
                $tempbody_details = $this->templates_model->get_usertemplate_data($bodyid);
                $body             = $tempbody_details['template_content'];
                $body             = str_replace('{USER_NAME}', $username, $body);
                $body             = str_replace('{sitetitle}', $this->site_name, $body);
                $body             = str_replace('{full_name}', ucfirst($this->input->post('fullname')), $body);
                $body             = str_replace('{password}', $password, $body);
                $message          = '<table style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; background-color: #f6f6f6; margin: 0;" bgcolor="#f6f6f6">
                      <tr>
                        <td></td>
                        <td width="600" style="box-sizing: border-box; vertical-align: top; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto;" valign="top">
                          <div style="box-sizing: border-box; max-width: 600px; display: block; margin: 0 auto; padding: 20px;">
                            <table width="100%" cellpadding="0" cellspacing="0" style="box-sizing: border-box; font-size: 14px; border-radius: 3px; background-color: #fff; margin: 0; border: 1px solid #e9e9e9;" bgcolor="#fff">
                              <tr>
                                <td style="box-sizing: border-box; vertical-align: top; text-align: left; margin: 0; padding: 20px;" valign="top">
                                  <table width="100%" cellpadding="0" cellspacing="0">
                                    <tr>
                                      <td style="text-align:center;">
                                        <a href="{base_url}" target="_blank"><img src="' . $this->logo_front . '" style="width:90px" /></a>
                                      </td>
                                    </tr>
                                    <tr>
                                      <td>' . $body . '</td>
                                    </tr>
                                  </table>
                                </td>
                              </tr>
                            </table>
                            <div style="box-sizing: border-box; width: 100%; clear: both; color: #999; margin: 0; padding: 15px 15px 0 15px;">
                              <table width="100%">
                                <tr>
                                  <td style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 12px; vertical-align: top; color: #999; text-align: center; margin: 0; padding: 0;" align="center" valign="top">
                                    &copy; ' . date("Y") . ' <a href="' . $this->base_domain . '" target="_blank" style="color:#bbadfc;" target="_blank">' . $this->site_name . '</a> All Rights Reserved.
                                  </td>
                                </tr>
                              </table>
                            </div>
                          </div>
                        </td>
                      </tr>
                    </table>';
                // $this->load->helper('file');
                // $this->load->library('email');
                // $this->email->initialize($this->smtp_config);
                // $this->email->set_newline("\r\n");
                // $this->email->from($this->email_address, $this->email_tittle);
                // $this->email->to($data['email']);
                // $this->email->subject('Welcome and thank you for joining ' . $this->site_name);
                // $this->email->message($message);
				
				
			$phpmail_config =  $this->mail_config;
            if (isset($phpmail_config) && !empty($phpmail_config)) {
                if ($phpmail_config == "phpmail") {
                    $from_email = $this->email_address;
                } else {
                    $from_email = $this->smtp_email_address;
                }
            }
			
			//$this->load->helper('file');
            $this->load->library('email');	
			//print_r($this->smtp_config);exit;
            if (!empty($from_email) && isset($from_email)) {
				 // $this->email->initialize($this->smtp_config);
				
                // $this->email->set_newline("\r\n");
                $mail = $this->email
                        ->from($from_email)
                        ->to($data['email'])
                        ->subject('Welcome and thank you for joining ' . $this->site_name)
                        ->message($message)
                        ->send();
					
					
					
            }
                if ($mail) {
                    $this->email->send();
					 echo 1;
                }
               
            } else {
                echo 0;
            }
        }
    }
    function getTimezoneGeo($geoplugin_latitude, $geoplugin_longitude, $t)
    {
        $json  = file_get_contents("https://maps.googleapis.com/maps/api/timezone/json?location=$geoplugin_latitude,$geoplugin_longitude&timestamp=$t&key=AIzaSyCrF-ZcLpYjLO7ygnisZJk_eHogmlzawwE ");
        $data  = json_decode($json, true);
        $tzone = $data['timeZoneId'];
        return $tzone;
    }
    public function forgot_password()
    {
        $email_id     = $this->input->post('forget_email');
        $query        = $this->db->query("SELECT username FROM  `members` WHERE  `email` =  '$email_id'");
        $username     = $query->row_array();
        $username     = trim($username['username']);
        //$url_encypted = urlencode($this->encryptor('encrypt', $username));
        $url_encypted = urlencode($username);
        $query        = $this->db->query("Update  `members` SET forget='$url_encypted' WHERE  `email` =  '$email_id'");
        $url          = base_url() . 'change_password/' . $url_encypted;
        $this->load->model('templates_model');
        $message          = '';
        $bodyid           = 14;
        $tempbody_details = $this->templates_model->get_usertemplate_data($bodyid);
        $body             = $tempbody_details['template_content'];
        $body             = str_replace('{sitetitle}', $this->site_name, $body);
        $body             = str_replace('{base_url}', $this->base_domain, $body);
        $body             = str_replace('{base_image}', $this->base_domain . '/' . $this->logo_front, $body);
        $body             = str_replace('{USER_NAME}', $username, $body);
        $body             = str_replace('{SUBMIT_LINK}', $url, $body);
        $message          = '<table style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; background-color: #f6f6f6; margin: 0;" bgcolor="#f6f6f6">
                <tr>
                  <td></td>
                  <td width="600" style="box-sizing: border-box; vertical-align: top; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto;" valign="top">
                    <div style="box-sizing: border-box; max-width: 600px; display: block; margin: 0 auto; padding: 20px;">
                      <table width="100%" cellpadding="0" cellspacing="0" style="box-sizing: border-box; font-size: 14px; border-radius: 3px; background-color: #fff; margin: 0; border: 1px solid #e9e9e9;" bgcolor="#fff">
                        <tr>
                          <td style="box-sizing: border-box; vertical-align: top; text-align: left; margin: 0; padding: 20px;" valign="top">
                            <table width="100%" cellpadding="0" cellspacing="0">
                              <tr>
                                <td style="text-align:center;">
                                  <a href="{base_url}" target="_blank"><img src="' . $this->logo_front . '" style="width:90px" /></a>
                                </td>
                              </tr>
                              <tr>
                                <td>' . $body . '</td>
                              </tr>
                            </table>
                          </td>
                        </tr>
                      </table>
                      <div style="box-sizing: border-box; width: 100%; clear: both; color: #999; margin: 0; padding: 15px 15px 0 15px;">
                        <table width="100%">
                          <tr>
                            <td style="font-family: Helvetica Neue,Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 12px; vertical-align: top; color: #999; text-align: center; margin: 0; padding: 0;" align="center" valign="top">
                              &copy; ' . date("Y") . ' <a href="' . $this->base_domain . '" target="_blank" style="color:#bbadfc;" target="_blank">' . $this->site_name . '</a> All Rights Reserved.
                            </td>
                          </tr>
                        </table>
                      </div>
                    </div>
                  </td>
                </tr>
              </table>';
        // $this->load->helper('file');
        // $this->load->library('email');
        // $this->email->initialize($this->smtp_config);
        // $this->email->set_newline("\r\n");
        // $this->email->from($this->email_address, $this->email_tittle);
        // $this->email->to($email_id);
        // $this->email->subject('Forgot Password on ' . $this->site_name);
        // $this->email->message($message);
		
		$phpmail_config =  $this->mail_config;//
            if (isset($phpmail_config) && !empty($phpmail_config)) {
                if ($phpmail_config == "phpmail") {
                    $from_email = $this->email_address;
                } else {
                    $from_email = $this->smtp_email_address;
                }
            }
			
			//$this->load->helper('file');
            $this->load->library('email');	
			//print_r($this->smtp_config);exit;
            if (!empty($from_email) && isset($from_email)) {
				 // $this->email->initialize($this->smtp_config);
				
                // $this->email->set_newline("\r\n");
                $mail = $this->email
                        ->from($from_email)
                        ->to($email_id)
                        ->subject('Forgot Password on ' . $this->site_name)
                        ->message($message)
                        ->send();
					
					
					
            }
        if ($mail) {
            echo 1;
        } else {
           echo 2;
        }
    }
    public function random_number_generator()
    {
        $random_number = rand(0, 999);
        return $random_number;
    }
    public function checking_suggestion($username_substring, $second_substring)
    {
        $counter              = 0;
        $username_suggestions = array();
        for ($i = 0; $i < 20; $i++) {
            if ($counter == 3) {
                $html = '';
                foreach ($username_suggestions as $usr_sugg) {
                    $html .= '<a href="#" data-username="\'' . $usr_sugg . '\'" class="select_username">' . $usr_sugg . '</a><br>';
                }
                return $html;
                break;
            }
            $username = $username_substring . $second_substring . "_" . $this->random_number_generator();
            $result   = $this->user_panel_model->check_username($username);
            if ($result != 1) {
                $counter                = $counter + 1;
                $username_suggestions[] = $username;
            }
        }
    }
    public function create_suggestions()
    {
        $username = $this->input->post('username');
        $mail_id  = $this->input->post('email');
        $result   = $this->user_panel_model->check_username($username);
        if ($result == 1) {
            $email_substring    = substr($mail_id, 0, 3);
            $username_substring = substr($username, 0, 3);
            if ($email_substring == $username_substring) {
                $pos              = strpos($mail_id, '@');
                $subtracted       = $pos - 3;
                $second_substring = substr($mail_id, 3, $subtracted);
                $return_result    = $this->checking_suggestion($username_substring, $second_substring);
            } else {
                $return_result = $this->checking_suggestion($username_substring, $email_substring);
            }
            echo json_encode(array(
                'html' => $return_result,
                'sub_html' => 1
            ));
        } else {
            $html = '<p> The username : ' . $username . ' is available </p>';
            echo json_encode(array(
                'html' => $html,
                'sub_html' => 2
            ));
        }
    }
    public function sell_gig()
    {
        $this->data['page'] = 'add_gigs';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/pages/template');
    }
    public function testjo()
    {
        echo json_encode(array(
            'html' => 'welcome'
        ));
    }
}
