<?php
class Wallet_payments extends CI_Controller
{
    public $data;
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->data['theme']  = 'admin';
        $this->data['module'] = 'wallet_payments';
        $this->load->model('admin_panel_model');
        $this->load->model('Stripe_model');
        $this->data['admin_commision'] = $this->admin_panel_model->admin_commision();
        $this->load->helper('common_helper');
    }
    public function index($offset = 0)
    {
        $this->load->library('pagination');
        $config['base_url']        = base_url("admin/completed_payments/");
        $config['per_page']        = 15;
        $config['total_rows']      = $this->admin_panel_model->wallet_payments(0, $offset, $config['per_page']);
        $config['full_tag_open']   = '<ul class="pagination">';
        $config['full_tag_close']  = '</ul>';
        $config['first_link']      = 'First';
        $config['first_tag_open']  = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['prev_link']       = '&laquo;';
        $config['prev_tag_open']   = '<li>';
        $config['prev_tag_close']  = '</li>';
        $config['cur_tag_open']    = '<li class="active"><a href="javascript:;">';
        $config['cur_tag_close']   = '</a></li>';
        $config['num_tag_open']    = '<li>';
        $config['num_tag_close']   = '</li>';
        $config['next_link']       = '&raquo;';
        $config['next_tag_open']   = '<li>';
        $config['next_tag_close']  = '</li>';
        $config['last_link']       = 'Last';
        $config['last_tag_open']   = '<li>';
        $config['last_tag_close']  = '</li>';
        $this->pagination->initialize($config);
        $this->data['page']  = 'index';
        $this->data['links'] = $this->pagination->create_links();
        $offset              = (int) $this->uri->segment(3);
        $this->data['list']  = $this->admin_panel_model->wallet_payments(1, $offset, $config['per_page']);
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function withdraw_update()
    {
        $params = $this->input->post();
        if (!empty($params)) {
            $data            = array(
                'transaction_status' => $params['transaction_status'],
                'transaction_id' => $params['transaction_id'],
                'transaction_date' => date('Y-m-d', strtotime($params['transaction_date'])),
                'description' => $params['description'],
                'updated_at' => date('Y-m-d H:i:s')
            );
            $result          = $this->db->where('id', $params['id'])->update('wallet_withdraw', $data);
            $wallet_withdraw = $this->db->where('id', $params['id'])->get('wallet_withdraw')->row_array();
            if ($result == true) {
                if ($params['transaction_status'] == 2) {
                    $user_currency = get_api_user_currency($wallet_withdraw['user_id']);
                    $amt           = get_gigs_currency($wallet_withdraw['amount'], $wallet_withdraw['currency_code'], $user_currency['user_currency_code']);
                    $results       = $this->Stripe_model->user_wallet_history_flow($wallet_withdraw['user_id'], '', $amt);
                    if ($results == true) {
                        $this->session->set_flashdata('message', '<p class="alert alert-success">Transaction  Updated SuccessFully</p>');
                        return redirect('admin/wallet_payments');
                    } else {
                        $this->session->set_flashdata('message', '<p class="alert alert-danger">Something went in Serve end</p>');
                        return redirect('admin/wallet_payments');
                    }
                } else {
                    $this->session->set_flashdata('message', '<p class="alert alert-success">Transaction  Updated SuccessFully</p>');
                    return redirect('admin/wallet_payments');
                }
            }
        }
    }
    public function get_bank_details()
    {
        $params = $this->input->post();
        if (!empty($params['id'])) {
            $bank_details = $this->db->where('user_id', $params['id'])->get('stripe_bank_details')->row_array();
            echo json_encode($bank_details);
            exit;
        }
    }
}