<?php
class Settings extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->data['theme']  = 'admin';
        $this->data['module'] = 'settings';
        $this->load->model('admin_panel_model');
		$this->load->model('common_model','common_model');
        $this->data['admin_id'] = $this->session->userdata('id');
        $this->user_role        = !empty($this->session->userdata('user_role')) ? $this->session->userdata('user_role') : 0;
        $this->load->helper('common_helper');
    }
    public function index()
    {
		$this->common_model->checkAdminUserPermission(7);
        removeTag($this->input->post());
        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/settings');
            } else if ($this->user_role == 1) {
                $this->load->library('upload');
                $data = $this->input->post();
                if ($_FILES['site_logo']['name']) {
                    $file = $_FILES["site_logo"]['tmp_name'];
                    list($width, $height) = getimagesize($file);
                    if ($width < "35" || $height < "35") {
                        $message .= '<hr/><div class="alert-adminpane alert-danger text-center fade in" id="flash_error_message">Please upload above 35x35 image size' . $error . '</div>';
                        $this->session->set_flashdata('error', $message);
                        redirect(base_url('admin/' . $this->data['module']));
                    }
                    $table_data1                 = array();
                    $configfile['upload_path']   = FCPATH . 'uploads/logo';
                    $configfile['allowed_types'] = 'gif|jpg|jpeg|png';
                    $configfile['overwrite']     = FALSE;
                    $configfile['remove_spaces'] = TRUE;
                    $file_name                   = $_FILES['site_logo']['name'];
                    $configfile['file_name']     = time() . '_' . $file_name;
                    $image_name                  = $configfile['file_name'];
                    $image_url                   = 'uploads/logo/' . $image_name;
                    $av_file                     = $_FILES['site_logo'];
                    $src                         = 'uploads/logo/' . $av_file['name'];
                    $imageFileType               = pathinfo($src, PATHINFO_EXTENSION);
                    $image_name                  = time() . '.' . $imageFileType;
                    $src2                        = 'uploads/logo/' . $image_name;
                    if (move_uploaded_file($av_file['tmp_name'], $src2)) {
                        if ($width != "35" && $height != "35") {
                            $medium_image = $this->image_resize('35', '35', $src2, $image_name);
                        }
                        if ($width == 35 && $height == 35) {
                            $medium_image = $src2;
                        }
                        $img_uploadurl = 'uploads/logo' . $_FILES['site_logo']['name'];
                        $key           = 'logo_front';
                        $val           = $medium_image;
                        $this->db->where('key', $key);
                    }
                    $this->db->delete('system_settings');
                    $table_data1['key']         = $key;
                    $table_data1['value']       = $val;
                    $table_data1['system']      = 1;
                    $table_data1['groups']      = 'config';
                    $table_data1['update_date'] = date('Y-m-d');
                    $table_data1['status']      = 1;
                    $this->db->insert('system_settings', $table_data1);
                }
                if ($_FILES['favicon']['name']) {
                    $img_uploadurl1              = '';
                    $table_data2                 = '';
                    $table_data                  = array();
                    $configfile['upload_path']   = FCPATH . 'uploads/logo';
                    $configfile['allowed_types'] = 'png|ico';
                    $configfile['overwrite']     = FALSE;
                    $configfile['remove_spaces'] = TRUE;
                    $configfile['max_width']     = 50;
                    $configfile['max_height']    = 50;
                    $file_name                   = $_FILES['favicon']['name'];
                    $configfile['file_name']     = $file_name;
                    $this->upload->initialize($configfile);
                    if ($this->upload->do_upload('favicon')) {
                        $img_uploadurl1  = $_FILES['favicon']['name'];
                        $key             = 'favicon';
                        $val             = $img_uploadurl1;
                        $select_fav_icon = $this->db->query("SELECT * FROM `system_settings` WHERE `key` = '$key' ");
                        $fav_icon_result = $select_fav_icon->row_array();
                        if (count($fav_icon_result) > 0) {
                            $this->db->where('key', $key);
                            $this->db->update('system_settings', array(
                                'value' => $val
                            ));
                        } else {
                            $table_data['key']   = $key;
                            $table_data['value'] = $val;
                            $this->db->insert('system_settings', $table_data);
                        }
                        $error = '';
                    } else {
                        $error = $this->upload->display_errors();
                    }
                }
                $this->db->where('key', 'razorpay_allow');
        $this->db->update('system_settings', array(
            'value' => $this->input->post('razorpay_allow')
        ));
        $this->db->where('key', 'razorpay_option');
        $this->db->update('system_settings', array(
            'value' => $this->input->post('razorpay_option')
        ));
                if ($data) {
                    $table_data           = array();
                    # paypal_option // 1 SandBox, 2 Live 
                    # paypal_allow  // 1 Active, 2 Inactive  
                    # stripe_option // 1 SandBox, 2 Live 
                    # stripe_allow  // 1 Active, 2 Inactive  
                    $live_publishable_key = $live_secret_key = $secret_key = $publishable_key = $razoropt = $razorallow = '';
                    $query                = $this->db->query("SELECT * FROM payment_gateways WHERE status = 1");
                    $stripe_details       = $query->result_array();
                    if (!empty($stripe_details)) {
                        foreach ($stripe_details as $details) {
                            if (strtolower($details['gateway_name']) == 'stripe') {
                                if (strtolower($details['gateway_type']) == 'sandbox') {
                                    $publishable_key = $details['api_key'];
                                    $secret_key      = $details['value'];
                                }
                                if (strtolower($details['gateway_type']) == 'live') {
                                    $live_publishable_key = $details['api_key'];
                                    $live_secret_key      = $details['value'];
                                }
                            }
                        }
                    }
					
                    $data['publishable_key']      = $publishable_key;
                    $data['secret_key']           = $secret_key;
                    $data['live_publishable_key'] = $live_publishable_key;
                    $data['live_secret_key']      = $live_secret_key;
                    $data['paypal_option']      = $this->input->post('paypal_option');
                    $data['paytabs_option']      = $this->input->post('paytabs_option');
                    $data['stripe_option']      = $this->input->post('stripe_option');
                    //$data['paypal_option']      = $this->input->post('paypal_option');
					
                    foreach ($data as $key => $val) {
                        if ($key != 'form_submit') {
                            $this->db->where('key', $key);
                            $this->db->delete('system_settings');
                            $table_data['key']         = $key;
                            $table_data['value']       = $val;
                            $table_data['system']      = 1;
                            $table_data['groups']      = 'config';
                            $table_data['update_date'] = date('Y-m-d');
                            $table_data['status']      = 1;
                            $this->db->insert('system_settings', $table_data);
                        }
                    }
                }
                //update social widgets
                $this->db->truncate('social_widgets');
                $fb_page_name            = $this->input->post('fb_page_name');
                $twitter_name            = $this->input->post('tw_name');
                $twitter_id              = $this->input->post('tw_widget_id');
                $sw_data['fb_page_name'] = ($fb_page_name != "") ? $fb_page_name : ''; //facebook
                $sw_data['twitter_name'] = ($twitter_name != "") ? $twitter_name : ''; //envato
                $sw_data['twitter_id']   = ($twitter_id != "") ? $twitter_id : ''; //461477479849291776
                $this->db->insert('social_widgets', $sw_data);
                $message = '';
                if (!empty($error)) {
                    $message .= '<hr/><div class="alert-adminpane alert-danger text-center fade in" id="flash_error_message">Image uploading failed ' . $error . '</div>';
                } else {
                    $message = '<div class="alert-adminpane alert-success text-center fade in" id="flash_succ_message">Settings saved successfully.</div>';
                }
                $this->session->set_flashdata('message', $message);
                redirect(base_url('admin/' . $this->data['module']));
            }
        }	
        
        $results = $this->admin_panel_model->get_setting_list();
        foreach ($results as $config) {
            $this->data[$config['key']] = $config['value'];
        }
        $this->data['currency'] = $this->db->where('status', 1)->get('currency_rate')->result_array();
        $this->data['page']     = 'index';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function image_resize($width = 0, $height = 0, $image_url, $filename)
    {
        $source_path = base_url() . $image_url;
        list($source_width, $source_height, $source_type) = getimagesize($source_path);
        switch ($source_type) {
            case IMAGETYPE_GIF:
                $source_gdim = imagecreatefromgif($source_path);
                break;
            case IMAGETYPE_JPEG:
                $source_gdim = imagecreatefromjpeg($source_path);
                break;
            case IMAGETYPE_PNG:
                $source_gdim = imagecreatefrompng($source_path);
                break;
        }
        $source_aspect_ratio  = $source_width / $source_height;
        $desired_aspect_ratio = $width / $height;
        if ($source_aspect_ratio > $desired_aspect_ratio) {
            $temp_height = $height;
            $temp_width  = (int) ($height * $source_aspect_ratio);
        } else {
            $temp_width  = $width;
            $temp_height = (int) ($width / $source_aspect_ratio);
        }
        $temp_gdim = imagecreatetruecolor($temp_width, $temp_height);
        imagecopyresampled($temp_gdim, $source_gdim, 0, 0, 0, 0, $temp_width, $temp_height, $source_width, $source_height);
        $x0           = ($temp_width - $width) / 2;
        $y0           = ($temp_height - $height) / 2;
        $desired_gdim = imagecreatetruecolor($width, $height);
        imagecopy($desired_gdim, $temp_gdim, 0, 0, $x0, $y0, $width, $height);
        $filename_without_extension = preg_replace('/\\.[^.\\s]{3,4}$/', '', $filename);
        $image_url                  = "uploads/logo/" . $filename_without_extension . "_" . $width . "_" . $height . ".jpg";
        imagejpeg($desired_gdim, $image_url);
        return $image_url;
    }
    public function emailsettings()
    {
		$this->common_model->checkAdminUserPermission(7);
        removeTag($this->input->post());
        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/settings');
            } else if ($this->user_role == 1) {
                $this->load->library('upload');
                $data = $this->input->post();
                if ($data) {
                    $table_data = array();
                    foreach ($data as $key => $val) {
                        if ($key != 'form_submit') {
                            $this->db->where('key', $key);
                            $this->db->delete('system_settings');
                            $table_data['key']         = $key;
                            $table_data['value']       = $val;
                            $table_data['system']      = 1;
                            $table_data['groups']      = 'config';
                            $table_data['update_date'] = date('Y-m-d');
                            $table_data['status']      = 1;
                            $this->db->insert('system_settings', $table_data);
                        }
                    }
                }
            }
            $message = '<div class="alert alert-success text-center fade in" id="flash_succ_message">Settings saved successfully.</div>';
            $this->session->set_flashdata('message', $message);
            redirect(base_url('admin/emailsettings'));
        }
        $results = $this->admin_panel_model->get_setting_list();
        foreach ($results as $config) {
            $this->data[$config['key']] = $config['value'];
        }
        $this->data['page'] = 'emailsettings';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function smtp_config()
    {
		$this->common_model->checkAdminUserPermission(7);
        removeTag($this->input->post());
        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/settings');
            } else if ($this->user_role == 1) {
                $this->load->library('upload');
                $data = $this->input->post();
                if ($data) {
                    $table_data = array();
                    foreach ($data as $key => $val) {
                        if ($key != 'form_submit') {
                            $this->db->where('key', $key);
                            $this->db->delete('system_settings');
                            $table_data['key']         = $key;
                            $table_data['value']       = $val;
                            $table_data['system']      = 1;
                            $table_data['groups']      = 'config';
                            $table_data['update_date'] = date('Y-m-d');
                            $table_data['status']      = 1;
                            $this->db->insert('system_settings', $table_data);
                        }
                    }
                }
            }
            $message = '<div class="alert alert-success text-center fade in" id="flash_succ_message">Settings saved successfully.</div>';
            $this->session->set_flashdata('message', $message);
            redirect(base_url('admin/settings/smtp_config'));
        }
        $results = $this->admin_panel_model->smtp_setting();
        foreach ($results as $config) {
            $this->data[$config['key']] = $config['value'];
        }
        $this->data['page'] = 'smtp_config';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function color()
    {
		$this->common_model->checkAdminUserPermission(7);
        removeTag($this->input->post());
        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/settings/color');
            } else if ($this->user_role == 1) {
                $this->load->library('upload');
                $data = $this->input->post();
                if ($_FILES['site_banner']['name']) {
                    $table_data1                 = array();
                    $configfile['upload_path']   = FCPATH . 'uploads/banner';
                    $configfile['allowed_types'] = 'gif|jpg|jpeg|png';
                    $configfile['overwrite']     = FALSE;
                    $configfile['remove_spaces'] = TRUE;
                    $file_name                   = $_FILES['site_banner']['name'];
                    $configfile['file_name']     = time() . '_' . $file_name;
                    $image_name                  = $configfile['file_name'];
                    $image_url                   = 'uploads/banner/' . $image_name;
                    $this->upload->initialize($configfile);
                    if ($this->upload->do_upload('site_banner')) {
                        $img_uploadurl = 'uploads/banner' . $_FILES['site_banner']['name'];
                        $key           = 'site_banner';
                        $val           = 'uploads/banner/' . $image_name;
                        $this->db->where('key', $key);
                    }
                    $this->db->delete('system_settings');
                    $table_data1['key']         = $key;
                    $table_data1['value']       = $val;
                    $table_data1['system']      = 1;
                    $table_data1['groups']      = 'config';
                    $table_data1['update_date'] = date('Y-m-d');
                    $table_data1['status']      = 1;
                    $this->db->insert('theme_settings', $table_data1);
                }
                if ($data) {
                    $table_data = array();
                    foreach ($data as $key => $val) {
                        if ($key != 'form_submit') {
                            $this->db->where('key', $key);
                            $this->db->delete('theme_settings');
                            $table_data['key']         = $key;
                            $table_data['value']       = $val;
                            $table_data['system']      = 1;
                            $table_data['groups']      = 'config';
                            $table_data['update_date'] = date('Y-m-d');
                            $table_data['status']      = 1;
                            $this->db->insert('theme_settings', $table_data);
                        }
                    }
                }
            }
        }
        $results = $this->admin_panel_model->get_theme_setting_list();
        foreach ($results as $config) {
            $this->data[$config['key']] = $config['value'];
        }
        $this->data['page'] = 'color';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
}