<?php
class Faq extends CI_Controller
{
    public $data;
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->data['theme']  = 'admin';
        $this->data['module'] = 'faq';
        $this->load->model('admin_panel_model');
        $this->load->model('common_model','common_model');

        $this->data['admin_id'] = $this->session->userdata('id');
        $this->user_role        = !empty($this->session->userdata('user_role')) ? $this->session->userdata('user_role') : 0;
        $this->load->helper('ckeditor');
        // Array with the settings for this instance of CKEditor (you can have more than one)
        $this->data['ckeditor_editor1'] = array(
            //id of the textarea being replaced by CKEditor
            'id' => 'ck_editor_textarea_id',
            // CKEditor path from the folder on the root folder of CodeIgniter
            'path' => 'assets/js/ckeditor',
            // optional settings
            'config' => array(
                'toolbar' => "Full",
                'filebrowserBrowseUrl' => base_url() . 'assets/js/ckfinder/ckfinder.html',
                'filebrowserImageBrowseUrl' => base_url() . 'assets/js/ckfinder/ckfinder.html?Type=Images',
                'filebrowserFlashBrowseUrl' => base_url() . 'assets/js/ckfinder/ckfinder.html?Type=Flash',
                'filebrowserUploadUrl' => base_url() . 'assets/js/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                'filebrowserImageUploadUrl' => base_url() . 'assets/js/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                'filebrowserFlashUploadUrl' => base_url() . 'assets/js/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
            )
        );
    }
    public function index($offset = 0)
    {
        $this->common_model->checkAdminUserPermission(16);

        $this->load->library('pagination');
        $config['base_url']        = site_url("admin/faq/");
        $config['total_rows']      = $this->db->count_all('page');
        $config['per_page']        = 20;
        $config['full_tag_open']   = '<ul class="pagination">';
        $config['full_tag_close']  = '</ul>';
        $config['first_link']      = 'First';
        $config['first_tag_open']  = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['prev_link']       = '&laquo;';
        $config['prev_tag_open']   = '<li>';
        $config['prev_tag_close']  = '</li>';
        $config['cur_tag_open']    = '<li class="active"><a href="javascript:;">';
        $config['cur_tag_close']   = '</a></li>';
        $config['num_tag_open']    = '<li>';
        $config['num_tag_close']   = '</li>';
        $config['next_link']       = '&raquo;';
        $config['next_tag_open']   = '<li>';
        $config['next_tag_close']  = '</li>';
        $config['last_link']       = 'Last';
        $config['last_tag_open']   = '<li>';
        $config['last_tag_close']  = '</li>';
        $this->pagination->initialize($config);
        $this->data['page']        = 'index';
        $this->data['lists']       = $this->admin_panel_model->get_faq_details($config['per_page'], $offset);
        //$this->data['footercount'] = $this->admin_panel_model->footercount();
        //$this->data['links']       = $this->pagination->create_links();
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function create()
    {
         $this->common_model->checkAdminUserPermission(17);

        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/faq');
            } else {
                //str_replace("world", "Peter", "Hello world!");
                $page_title               = $this->input->post('page_title');
                $table_data['page_title'] = $page_title;
                $table_data['description'] = $this->input->post('page_desc');;

                if ($this->db->insert('faq', $table_data)) {
                    $message = '<div class="alert alert-success text-center fade in" id="flash_succ_message">FAQ added successfully. </div>';
                    $this->session->set_flashdata('message', $message);
                    redirect(base_url('admin/' . $this->data['module']));
                }
            }
        }
        $this->data['page'] = 'create';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function edit($cls_id)
    {
        $this->common_model->checkAdminUserPermission(16);

        $current_date = date('Y-m-d H:i:s');
        if ($this->data['admin_id'] > 1) {
            $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
            redirect(base_url() . 'admin/faq');
        } else {
            if (!empty($cls_id)) {
                if ($this->input->post('form_submit')) {
                $page_title               = $this->input->post('page_title');
                $table_data['page_title'] = $page_title;
                $table_data['description'] = $this->input->post('page_desc');;

                    $this->db->update('faq', $table_data, "faq_id = " . $cls_id);
                    $message = '<div class="alert alert-success text-center fade in" id="flash_succ_message">FAQ edited successfully. </div>';
                    $this->session->set_flashdata('message', $message);
                    redirect(base_url('admin/' . $this->data['module']));
                }
                $this->data['datalist'] = $this->admin_panel_model->edit_faq_details($cls_id);
                $this->data['page']     = 'edit';
                $this->load->vars($this->data);
                $this->load->view($this->data['theme'] . '/template');
            } else {
                redirect(base_url('admin/' . $this->data['module']));
            }
        }
    }
    public function delete_faq_menu()
    {
            $this->common_model->checkAdminUserPermission(17);

        if ($this->data['admin_id'] > 1) {
            $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
            redirect(base_url() . 'admin/faq');
        } else {
            $id = $this->input->post('tbl_id');
            if (!empty($id)) {
                $this->db->delete('faq', array(
                    'faq_id' => $id
                ));
                $message = '<div class="alert alert-success text-center fade in" id="flash_succ_message">FAQ delete successfully. </div>';
                echo 1;
            }
            $this->session->set_flashdata('message', $message);
        }
    }
    
}