<?php
class Category extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        error_reporting(0);
        $this->data['theme']  = 'admin';
        $this->data['module'] = 'category';
        $this->load->model('admin_panel_model');
		$this->load->model('common_model','common_model');
        $this->data['admin_id'] = $this->session->userdata('id');
        $this->user_role        = !empty($this->session->userdata('user_role')) ? $this->session->userdata('user_role') : 0;
        $this->load->helper('common_helper');
    }
    public function index()
    {
		 $this->common_model->checkAdminUserPermission(3);
        $this->data['page'] = 'index';
        $this->data['list'] = $this->admin_panel_model->all_category();
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function image_resize($width = 0, $height = 0, $image_url, $filename)
    {
        $source_path = base_url() . $image_url;
        list($source_width, $source_height, $source_type) = getimagesize($source_path);
        switch ($source_type) {
            case IMAGETYPE_GIF:
                $source_gdim = imagecreatefromgif($source_path);
                break;
            case IMAGETYPE_JPEG:
                $source_gdim = imagecreatefromjpeg($source_path);
                break;
            case IMAGETYPE_PNG:
                $source_gdim = imagecreatefrompng($source_path);
                break;
        }
        $source_aspect_ratio  = $source_width / $source_height;
        $desired_aspect_ratio = $width / $height;
        if ($source_aspect_ratio > $desired_aspect_ratio) {
            $temp_height = $height;
            $temp_width  = (int) ($height * $source_aspect_ratio);
        } else {
            $temp_width  = $width;
            $temp_height = (int) ($width / $source_aspect_ratio);
        }
        $temp_gdim = imagecreatetruecolor($temp_width, $temp_height);
        imagecopyresampled($temp_gdim, $source_gdim, 0, 0, 0, 0, $temp_width, $temp_height, $source_width, $source_height);
        $x0           = ($temp_width - $width) / 2;
        $y0           = ($temp_height - $height) / 2;
        $desired_gdim = imagecreatetruecolor($width, $height);
        imagecopy($desired_gdim, $temp_gdim, 0, 0, $x0, $y0, $width, $height);
        $filename_without_extension = preg_replace('/\\.[^.\\s]{3,4}$/', '', $filename);
        $image_url                  = "uploads/category/mini_images/" . $filename_without_extension . "_" . $width . "_" . $height . ".jpg";
        imagejpeg($desired_gdim, $image_url);
        return $image_url;
    }
    public function add_category()
    {
		 $this->common_model->checkAdminUserPermission(3);
        removeTag($this->input->post());
        $this->data['page']            = 'add_category';
        $this->data['parent_category'] = $this->admin_panel_model->parent_category();
        if ($this->input->post('form_submit')) {
            if ($this->data['admin_id'] > 1) {
                $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
                redirect(base_url() . 'admin/category');
            } else {
                $data['parent'] = $this->input->post('parent_category');
                $data['name']   = $this->input->post('category_name');
                $data['status'] = 0;
                if ($this->db->insert('categories', $data)) {
                    $message = "<div class='alert alert-success text-center fade in' id='flash_succ_message'>Category Successfully Added</div>";
                }
                $insert_id = $this->db->insert_id();
                if (isset($_FILES) && !empty($_FILES['category_image']['name'])) {
                    $av_file       = $_FILES['category_image'];
                    $src           = 'uploads/category/' . $av_file['name'];
                    $imageFileType = pathinfo($src, PATHINFO_EXTENSION);
                    $image_name    = time() . '.' . $imageFileType;
                    $src2          = 'uploads/category/' . $image_name;
                    move_uploaded_file($av_file['tmp_name'], $src2);
                    $medium_image = $this->image_resize('256', '256', $src2, $image_name);
                    $this->db->where('CATID=', $insert_id)->update('categories', array(
                        'category_image' => $src2,
                        'category_medium_image' => $medium_image
                    ));
                }
                $this->session->set_flashdata('message', $message);
                redirect(base_url() . 'admin/category');
            }
        }
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function edit_category($category_id)
    {
		 $this->common_model->checkAdminUserPermission(3);
        $this->data['page']            = 'edit_category';
        $this->data['parent_category'] = $this->admin_panel_model->parent_category();
        $this->data['list']            = $this->admin_panel_model->edit_category($category_id);
        if ($this->data['admin_id'] > 1) {
            $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
            redirect(base_url() . 'admin/category');
        } else {
            if ($this->input->post('form_submit')) {
                $data['parent']  = $this->input->post('parent_category');
                $data['name']    = $this->input->post('category_name');
                $data['seo']     = $this->input->post('cat_seo_name');
                $data['details'] = $this->input->post('category_description');
                $data['mtitle']  = $this->input->post('page_title');
                $data['mdesc']   = $this->input->post('category_meta_desc');
                $data['mtags']   = $this->input->post('category_meta_keywords');
                $this->load->library('common');
                $data['status'] = $this->input->post('status');
                $this->db->where('CATID', $category_id);
                if ($this->db->update('categories', $data)) {
                    $message = "<div class='alert alert-success text-center fade in' id='flash_succ_message'>Category Successfully updated.</div>";
                }
                $insert_id = $category_id;
                if (isset($_FILES) && !empty($_FILES['category_image']['name'])) {
                    $av_file       = $_FILES['category_image'];
                    $src           = 'uploads/category/' . $av_file['name'];
                    $imageFileType = pathinfo($src, PATHINFO_EXTENSION);
                    $image_name    = time() . '.' . $imageFileType;
                    $src2          = 'uploads/category/' . $image_name;
                    move_uploaded_file($av_file['tmp_name'], $src2);
                    $medium_image = $this->image_resize('256', '256', $src2, $image_name);
                    $this->db->where('CATID=', $insert_id)->update('categories', array(
                        'category_image' => $src2,
                        'category_medium_image' => $medium_image
                    ));
                }
                $this->session->set_flashdata('message', $message);
                redirect(base_url() . 'admin/category');
            }
        }
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template');
    }
    public function delete_category()
    {
		  $this->common_model->checkAdminUserPermission(3);
        if ($this->data['admin_id'] > 1) {
            $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
            redirect(base_url() . 'admin/category');
        } else {
            $id = $this->input->post('tbl_id');
            $this->db->where('CATID', $id);
            if ($this->db->delete('categories')) {
                $message = "<div class='alert alert-success text-center fade in' id='flash_succ_message'>Category Successfully Deleted.</div>";
                echo 1;
            }
            $this->session->set_flashdata('message', $message);
        }
    }
    public function multiple_delete()
    {
		  $this->common_model->checkAdminUserPermission(3);
        if ($this->data['admin_id'] > 1) {
            $this->session->set_flashdata('message', '<p class="alert alert-danger">Permission Denied</p>');
            redirect(base_url() . 'admin/category');
        } else {
            $id = explode(',', $this->input->post('multi_Delete'));
            for ($i = 0; $i < count($id); $i++) {
                $this->db->where('CATID', $id[$i]);
                $result = $this->db->delete('categories');
            }
            if ($resul) {
                $message = "<div class='alert alert-success text-center fade in' id='flash_succ_message'>Category Successfully Deleted.</div>";
                echo 1;
            }
            $this->session->set_flashdata('message', $message);
            redirect(base_url() . 'admin/category');
        }
    }
}
