<?php
class Home extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        error_reporting(E_ALL);
        $this->load->helper('currency');
        $this->data['title']  = 'Home';
        $this->data['theme']  = 'user';
        $this->data['module'] = 'home';
        $this->load->model('user_panel_model');
        $this->load->model('follow_to_model');
        $this->load->model('notification_model');
        $this->load->model('gigs_model');
        $this->load->model('Stripe_model');
        $this->load->helper('custom_language');
        $default_language_select = default_language();
        if ($this->session->userdata('user_select_language') == '') {
            $this->data['user_selected'] = $default_language_select['language_value'];
        } else {
            $this->data['user_selected'] = $this->session->userdata('user_select_language');
        }
        $this->data['active_language']  = $active_lang = active_language();
        $lg                             = custom_language($this->data['user_selected']);
        $this->data['default_language'] = $lg['default_lang'];
        $this->data['user_language']    = $lg['user_lang'];
        $this->user_selected            = (!empty($this->data['user_selected'])) ? $this->data['user_selected'] : 'en';
        $this->default_language         = (!empty($this->data['default_language'])) ? $this->data['default_language'] : '';
        $this->user_language            = (!empty($this->data['user_language'])) ? $this->data['user_language'] : '';
        $this->load->helper('favourites');
        $this->data['country_list'] = $this->user_panel_model->country_list();
        $common_settings            = gigs_settings();
        $default_currency           = 'USD';
        if (!empty($common_settings)) {
            foreach ($common_settings as $datas) {
                if ($datas['key'] == 'currency_option') {
                    $default_currency = $datas['value'];
                }
            }
        }
        $this->load->helper('currency');
        $this->default_currency           = $default_currency;
        $this->default_currency_sign      = currency_sign($default_currency);
        $this->smtp_config                = smtp_mail_config();
        $this->data['currency_option']    = 'USD';
        /***********************Stripe API Key and Secret Key  ***************************/
        $this->data['secret_key']         = '';
        $this->data['publishable_key']    = '';
        $publishable_key                  = '';
        $secret_key                       = '';
        $live_publishable_key             = '';
        $live_secret_key                  = '';
        $stripe_option                    = '';
        /***********************Stripe API Key and Secret Key  ***************************/
        /***********************Amplifypay API Key and Secret Key  ***************************/
        $this->data['amplify_api_key']    = '';
        $this->data['amplify_secret_key'] = '';
        $this->data['paypal_allow']       = '';
        $this->data['paytabs_allow']      = '';
        $this->data['stripe_allow']       = '';
        $demo_amplify_api_key             = '';
        $demo_amplify_secret_key          = '';
        $live_amplify_api_key             = '';
        $live_amplify_secret_key          = '';
        $amplifypay_option                = '';
        /***********************Amplifypay API Key and Secret Key  ***************************/
        if (!empty($common_settings)) {
            foreach ($common_settings as $datas) {
                if ($datas['key'] == 'paypal_allow') {
                    $this->data['paypal_allow'] = $datas['value'];
                }
                if ($datas['key'] == 'paytabs_allow') {
                    $this->data['paytabs_allow'] = $datas['value'];
                }
                if ($datas['key'] == 'stripe_allow') {
                    $this->data['stripe_allow'] = $datas['value'];
                }
                if ($datas['key'] == 'secret_key') {
                    $secret_key = $datas['value'];
                }
                if ($datas['key'] == 'publishable_key') {
                    $publishable_key = $datas['value'];
                }
                if ($datas['key'] == 'live_secret_key') {
                    $live_secret_key = $datas['value'];
                }
                if ($datas['key'] == 'live_publishable_key') {
                    $live_publishable_key = $datas['value'];
                }
                if ($datas['key'] == 'stripe_option') {
                    $stripe_option = $datas['value'];
                }
                if ($datas['key'] == 'amplifypay_option') {
                    $amplifypay_option = $datas['value'];
                }
                if ($datas['key'] == 'amplifypay_api_key') {
                    $demo_amplify_api_key = $datas['value'];
                }
                if ($datas['key'] == 'amplifypay_merchant_id') {
                    $demo_amplify_secret_key = $datas['value'];
                }
                if ($datas['key'] == 'live_amplifypay_api_key') {
                    $live_amplify_api_key = $datas['value'];
                }
                if ($datas['key'] == 'live_amplifypay_merchant_id') {
                    $live_amplify_secret_key = $datas['value'];
                }
                if ($datas['key'] == 'currency_option') {
                    $this->data['currency_option'] = $datas['value'];
                }
            }
            if (@$stripe_option == 1) {
                $this->data['publishable_key'] = $publishable_key;
                $this->data['secret_key']      = $secret_key;
            }
            if (@$stripe_option == 2) {
                $this->data['publishable_key'] = $live_publishable_key;
                $this->data['secret_key']      = $live_secret_key;
            }
            if ($amplifypay_option == 1) {
                $this->data['amplify_api_key']    = $demo_amplify_api_key;
                $this->data['amplify_secret_key'] = $demo_amplify_secret_key;
            }
            if ($amplifypay_option == 2) {
                $this->data['amplify_api_key']    = $live_amplify_api_key;
                $this->data['amplify_secret_key'] = $live_amplify_secret_key;
            }
        }
        $this->data['client_list']              = $this->user_panel_model->get_client_list();
        $this->data['categories_subcategories'] = $this->user_panel_model->categories_subcategories();
        $this->data['logo']                     = $this->user_panel_model->get_logo();
        $this->data['slogan']                   = $this->user_panel_model->get_slogan();
        $this->data['footer_main_menu']         = $this->user_panel_model->footer_main_menu();
        $this->data['footer_sub_menu']          = $this->user_panel_model->footer_sub_menu();
        $this->data['system_setting']           = $this->user_panel_model->system_setting();
        $this->data['policy_setting']           = $this->user_panel_model->policy_setting();
        $this->data['country_list']             = $this->user_panel_model->country_list();
        $this->data['gig_price']                = $this->gigs_model->gig_price();
        $this->data['extra_gig_price']          = $this->gigs_model->extra_gig_price();
        $this->data['price_option']             = $this->gigs_model->get_setting_price_option();
        $this->data['sliderval']                =$this->gigs_model->get_slider_bg_image('Slider_bg');
        $this->data['advbanner']                =$this->gigs_model->get_advbanner_image('Advertise');
        $this->data['icons_g']                =$this->gigs_model->get_sectionic_image('Section3-Icon');



        $user_id                                = $this->session->userdata('SESSION_USER_ID');
        if ($user_id != '') {
            $settings = $this->gigs_model->settings();
            if (!empty($settings)) {
                foreach ($settings as $key => $value) {
                    $this->data[$key] = $value;
                }
            }
            $this->data['one_signal_user_id'] = $user_id;
     
        }
        $LAST_ACTIVITY = $this->session->userdata('LAST_ACTIVITY');
        if (isset($LAST_ACTIVITY) && (time() - $LAST_ACTIVITY > 86400)) {
            session_unset(); // unset $_SESSION variable for the run-time
            session_destroy(); // destroy session data in storage
            redirect(base_url());
        }
        if (($this->session->userdata('time_zone'))) { // Getting timezone from session
            $this->data['time_zone']   = $this->session->userdata('time_zone');
            $this->data['dollar_rate'] = $this->session->userdata('dollar_rate');
            $rupee_rate                = '';
            if ($this->data['dollar_rate'] != 0) {
                $rupee_rate = (1 / $this->data['dollar_rate']);
            }
            $this->data['rupee_rate'] = $rupee_rate;
            $data['user_timezone']    = $this->data['time_zone'];
            $user_id                  = $this->session->userdata('SESSION_USER_ID');
            $this->db->where('USERID', $user_id);
            $this->db->update('members', $data);
        } else {
            if ($this->session->userdata('LAST_ACTIVITY') == '') {
                $this->session->set_userdata('LAST_ACTIVITY', time());
            }
            if (isset($this->data['dollar_rate'])) {
                $this->session->set_userdata('dollar_rate', $this->data['dollar_rate']);
            }
            if (isset($this->data['rupee_rate'])) {
                $this->session->set_userdata('rupee_rate', $this->data['rupee_rate']);
            }
        }
        if ($this->session->userdata('SESSION_USER_ID')) {
            $this->data['user_favorites'] = $this->gigs_model->add_favourites();
            $this->data['recommended_users'] = $this->follow_to_model->get_recommend_users($user_id);
            
        }
        $gig_price                     = $this->gigs_model->gig_price();
        $this->data['gig_price']       = $gig_price['value'];
        $extra_gig_price               = $this->gigs_model->extra_gig_price();
        $this->data['extra_gig_price'] = $extra_gig_price['value'];
    }
    public function index()
    {
        $this->data['page_title']         = 'Home Page';
        $this->data['popular_gigs']       = $this->gigs_model->popular_gigs(1);
        $this->data['popular_gigs_limit'] = $this->gigs_model->popular_gigs_limit();
        $this->data['popular_category']   = $this->gigs_model->popular_category();
        $this->data['user_favorites']     = $this->gigs_model->add_favourites();
        $this->data['recent_gigs']        = $this->gigs_model->recent_gigs(1);
        $this->data['trending_gigs']      = $this->gigs_model->trending_gigs(1);
        $this->data['rating_gigs']        = $this->gigs_model->rating_gigs(1);
        $this->data['gigs_country']       = $this->gigs_model->gigs_country();
        $this->data['gigs_state_id']      = 0;
        $this->data['gigs_country_id']    = 0;
        $this->data['page']               = 'index';
        $this->load->vars($this->data);
        $this->load->view($this->data['theme'] . '/template2');
        $this->data['basic_details'] = $basic_details;
        $this->data['gig_details']   = $gig_details;
    }
}
